<?php if (isset($component)) { $__componentOriginal91fdd17964e43374ae18c674f95cdaa3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3 = $attributes; } ?>
<?php $component = App\View\Components\AdminLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h1 class="text-2xl font-bold">Tour Guide Details</h1>
     <?php $__env->endSlot(); ?>

    <div class="p-6 bg-white rounded-lg shadow-md dark:bg-gray-800">
        <div class="mb-4">
            <h2 class="ml-2 text-xl font-semibold text-gray-900 dark:text-gray-100">Basic Information</h2>
            <p class="mt-2 text-gray-600 dark:text-gray-400">First Name: <span class="font-medium"><?php echo e($tourGuide->first_name); ?></span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Last Name: <span class="font-medium"><?php echo e($tourGuide->last_name); ?></span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Japanese Name: <span class="font-medium"><?php echo e($tourGuide->japanese_name); ?></span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Email: <span class="font-medium"><?php echo e($tourGuide->email); ?></span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Phone: <span class="font-medium"><?php echo e($tourGuide->phone); ?></span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">DOB: <span class="font-medium"><?php echo e($tourGuide->dob); ?></span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Gender: <span class="font-medium"><?php echo e(ucfirst($tourGuide->gender)); ?></span></p>
        </div>

        <hr class="m-4">
        <div class="mb-4">
            <h2 class="ml-2 text-xl font-semibold text-gray-900 dark:text-gray-100">Location Details</h2>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Region: <span class="font-medium"><?php echo e($tourGuide->region->eng_name ?? 'N/A'); ?></span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Prefecture: <span class="font-medium"><?php echo e($tourGuide->prefecture->eng_name ?? 'N/A'); ?></span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">City: <span class="font-medium"><?php echo e($tourGuide->city->eng_name ?? 'N/A'); ?></span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Station: <span class="font-medium"><?php echo e($tourGuide->station); ?></span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Address: <span class="font-medium"><?php echo e($tourGuide->address); ?></span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Lat/Long: <span class="font-medium"><?php echo e($tourGuide->lat_long); ?></span></p>
        </div>

        <hr class="m-4">
        <div class="mb-4">
            <h2 class="ml-2 text-xl font-semibold text-gray-900 dark:text-gray-100">Guide Experience</h2>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Years of Experience: <span class="font-medium"><?php echo e($tourGuide->years_of_experience); ?></span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Number of Tours: <span class="font-medium"><?php echo e($tourGuide->number_of_tours); ?></span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Job Experience: <span class="font-medium"><?php echo e($tourGuide->job_experience); ?></span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">English Fluency: <span class="font-medium"><?php echo e($tourGuide->english_fluency); ?></span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Other Languages:
                <?php
                    $selectedLanguages = json_decode($tourGuide->other_languages, true) ?? [];
                ?>
                <?php if(!empty($selectedLanguages)): ?>
                    <span class="font-medium">
                        <?php echo e(implode(', ', collect($other_languages)->whereIn('id', $selectedLanguages)->pluck('name')->toArray())); ?>

                    </span>
                <?php else: ?>
                    <span class="text-gray-500">No other languages</span>
                <?php endif; ?>
            </p>
        </div>

        <hr class="m-4">
        <div class="mb-4">
            <h2 class="ml-2 text-xl font-semibold text-gray-900 dark:text-gray-100">Tour Details</h2>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Types of Tours:
                <span class="font-medium">
                    <?php echo e(implode(', ', json_decode($tourGuide->type_of_tours, true) ?? [])); ?>

                </span>
            </p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Tour Guide Areas:</p>
            <ul class="mt-2 list-disc list-inside text-gray-600 dark:text-gray-400">
                <?php $__currentLoopData = json_decode($tourGuide->guide_areas, true) ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li>
                        <span class="font-medium">Region:</span> <?php echo e(getRegionName($area['region'])); ?>,
                        <span class="font-medium">Prefecture:</span> <?php echo e(getPrefectureName($area['prefecture'])); ?>,
                        <span class="font-medium">Cities:</span>
                        <?php echo e(implode(', ', array_map('getCityName', $area['cities']))); ?>

                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Experience Area: <span class="font-medium"><?php echo e($tourGuide->experience_area); ?></span></p>
        </div>

        <hr class="m-4">
        <div class="mb-4">
            <h2 class="ml-2 text-xl font-semibold text-gray-900 dark:text-gray-100">Vehicle Details</h2>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Private Vehicle: <span class="font-medium"><?php echo e($tourGuide->private_vehicle ? 'Yes' : 'No'); ?></span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Car Type: <span class="font-medium"><?php echo e($tourGuide->car_type); ?></span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Capacity: <span class="font-medium"><?php echo e($tourGuide->capacity); ?></span></p>
        </div>

        <hr class="m-4">
        <div class="mb-4">
            <h2 class="ml-2 text-xl font-semibold text-gray-900 dark:text-gray-100">Financial Information</h2>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Invoice Registration: <span class="font-medium"><?php echo e($tourGuide->invoice_registration); ?></span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Invoice Number: <span class="font-medium"><?php echo e($tourGuide->invoice_registration_number); ?></span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Bank Info: <span class="font-medium"><?php echo e($tourGuide->bank_information); ?></span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Starting Rate: <span class="font-medium"><?php echo e($tourGuide->starting_rate); ?></span></p>
            <!-- Guide Fee Table -->
            <div class="mt-4">
                <label class="block text-gray-700 font-medium mb-2">Guide Fee (Hourly Rate)</label>
                <table class="w-full border-collapse border">
                    <thead>
                        <tr class="bg-green-300">
                            <th class="border p-2"># of People</th>
                            <th class="border p-2">7 - 8+ hours</th>
                            <th class="border p-2">5 - 6 hours</th>
                            <th class="border p-2">1 - 4 hours</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $fees = is_string($tourGuide->guide_fee) ? json_decode($tourGuide->guide_fee, true) : $tourGuide->guide_fee;
                        ?>
                        <tr>
                            <td class="border p-2 bg-green-200">1 - 6 people</td>
                            <td class="border p-2"><?php echo e($fees[1] ?? '-'); ?></td>
                            <td class="border p-2"><?php echo e($fees[101] ?? '-'); ?></td>
                            <td class="border p-2"><?php echo e($fees[201] ?? '-'); ?></td>
                        </tr>
                        <tr>
                            <td class="border p-2 bg-green-200">7 - 15 people</td>
                            <td class="border p-2"><?php echo e($fees[301] ?? '-'); ?></td>
                            <td class="border p-2"><?php echo e($fees[401] ?? '-'); ?></td>
                            <td class="border p-2"><?php echo e($fees[501] ?? '-'); ?></td>
                        </tr>
                        <tr>
                            <td class="border p-2 bg-green-200">16 - 27 people</td>
                            <td class="border p-2"><?php echo e($fees[601] ?? '-'); ?></td>
                            <td class="border p-2"><?php echo e($fees[701] ?? '-'); ?></td>
                            <td class="border p-2"><?php echo e($fees[801] ?? '-'); ?></td>
                        </tr>
                        <tr>
                            <td class="border p-2 bg-green-200">28+ people</td>
                            <td class="border p-2"><?php echo e($fees[901] ?? '-'); ?></td>
                            <td class="border p-2"><?php echo e($fees[1001] ?? '-'); ?></td>
                            <td class="border p-2"><?php echo e($fees[1101] ?? '-'); ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <hr class="m-4">
        <div class="mb-4">
            <h2 class="ml-2 text-xl font-semibold text-gray-900 dark:text-gray-100">Contract & Documents</h2>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Contract:
                <a href="<?php echo e(asset($tourGuide->contract)); ?>" class="text-indigo-600 dark:text-indigo-400 hover:underline">
                    View Contract
                </a>
            </p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Interview By:
                <?php
                    $interviewer = collect($managers)->firstWhere('id', $tourGuide->interviewed_by ?? null);
                ?>
                <?php if($interviewer): ?>
                    <span class="font-medium"><?php echo e($interviewer['name']); ?></span>
                <?php else: ?>
                    <span class="text-gray-500">No Interview By</span>
                <?php endif; ?>
            </p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Interview Date: <span class="font-medium"><?php echo e($tourGuide->interview_date); ?></span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Interview's Observation: <span class="font-medium"><?php echo e($tourGuide->interiewer_observations); ?></span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Sign Date: <span class="font-medium"><?php echo e($tourGuide->sign_date); ?></span></p>
        </div>

        <div class="flex items-center justify-between mt-4">
            <a href="<?php echo e(route('admin.tour-guides.index')); ?>" class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">
                Back to Tour Guide List
            </a>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $attributes = $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $component = $__componentOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php /**PATH C:\xampp8.2\htdocs\Portal\resources\views/admin/tour_guide/show.blade.php ENDPATH**/ ?>