<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\GroupController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\PermissionController;
use App\Http\Controllers\Admin\ResponseTemplateController;
use App\Http\Controllers\Admin\ChannelController;
use App\Http\Controllers\Admin\ChannelCommissionController;
use App\Http\Controllers\Admin\TourSettingController;
use App\Http\Controllers\Admin\TourGuideController;
use App\Http\Controllers\TourGuideApplicationController;
use App\Http\Controllers\Admin\LocationController;

Route::get('/lang/{locale}', function ($locale) {
    if (! in_array($locale, config('localization.locales'))) {
        abort(400);
    }

    session(['localization' => $locale]);
    app()->setLocale($locale);

    return redirect()->back();
})->name('lang.switch');

Route::get('/', function () {
    return redirect()->route('login');
});

// Tour Guide Application
Route::resource('/tour-guide-application', TourGuideApplicationController::class);

// Get City
Route::get('/get-prefectures', [LocationController::class, 'getPrefectures'])->name('get.prefectures');
Route::get('/get-cities', [LocationController::class, 'getCities'])->name('get.cities');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

Route::middleware('auth')->group(function () {
    Route::get('/admin', function () {
        return view('admin.dashboard');
    })->middleware('permission:dashboard')->name('admin.dashboard');

 });

 // Group routes that need admin role and authentication
Route::middleware(['auth', 'role:admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::resource('permissions', PermissionController::class);
});



Route::prefix('admin')->name('admin.')->middleware('auth')->group(function () {

    Route::resource('roles', RoleController::class)->middleware('permission:roles');
    Route::get('/users/enabled', [UserController::class, 'enabledUsers'])->middleware('permission:user-list')->name('users.enabled');
    Route::get('/users/disabled', [UserController::class, 'disabledUsers'])->middleware('permission:user-list')->name('users.disabled');
    Route::get('/users/trashed', [UserController::class, 'trashed'])->middleware('permission:user-list')->name('users.trashed');
    Route::resource('users', UserController::class)->middleware('permission:user-list');
    Route::get('/users/create', [UserController::class, 'create'])->middleware('permission:user-add')->name('users.create');
    Route::get('/users/{user}/edit', [UserController::class, 'edit'])->middleware('permission:user-edit')->name('users.edit');
    Route::delete('/users/{user}', [UserController::class, 'destroy'])->middleware('permission:user-delete')->name('users.destroy');
    Route::patch('/users/{user}/toggle-status', [UserController::class, 'toggleStatus'])->middleware('permission:user-edit')->name('users.toggle-status');

    // Groups
    Route::get('/groups/enabled', [GroupController::class, 'enabledGroups'])->middleware('permission:group-enable-disable')->name('groups.enabled');
    Route::get('/groups/disabled', [GroupController::class, 'disabledGroups'])->middleware('permission:group-enable-disable')->name('groups.disabled');
    Route::get('groups/trashed', [GroupController::class, 'trashed'])->middleware('permission:group-delete')->name('groups.trashed');
    Route::resource('groups', GroupController::class)->middleware('permission:group-list');
    Route::get('/groups/create', [GroupController::class, 'create'])->middleware('permission:group-add')->name('groups.create');
    Route::get('/groups/{group}/edit', [GroupController::class, 'edit'])->middleware('permission:group-edit')->name('groups.edit');
    Route::delete('/groups/{group}', [GroupController::class, 'destroy'])->middleware('permission:group-delete')->name('groups.destroy');
    Route::get('groups/restore/{id}', [GroupController::class, 'restore'])->middleware('permission:group-delete')->name('groups.restore');
    Route::delete('groups/force-delete/{id}', [GroupController::class, 'forceDelete'])->middleware('permission:group-delete')->name('groups.force-delete');
    Route::patch('/groups/{group}/toggle-status', [GroupController::class, 'toggleStatus'])->middleware('permission:group-enable-disable')->name('groups.toggle-status');

    // Response Templates
    Route::get('/response_templates/enabled', [ResponseTemplateController::class, 'enabledResponseTemplates'])->middleware('permission:response-template-enable-disable')->name('response_templates.enabled');
    Route::get('/response_templates/disabled', [ResponseTemplateController::class, 'disabledResponseTemplates'])->middleware('permission:response-template-enable-disable')->name('response_templates.disabled');
    Route::get('response_templates/trashed', [ResponseTemplateController::class, 'trashed'])->middleware('permission:response-template-delete')->name('response_templates.trashed');
    Route::resource('response_templates', ResponseTemplateController::class)->middleware('permission:response-template-list')->names('response_templates');
    Route::get('/response_templates/create', [ResponseTemplateController::class, 'create'])->middleware('permission:response-template-add')->name('response_templates.create');
    Route::get('/response_templates/{response-template}/edit', [ResponseTemplateController::class, 'edit'])->middleware('permission:response-template-edit')->name('response_templates.edit');
    Route::delete('/response_templates/{response-template}', [ResponseTemplateController::class, 'destroy'])->middleware('permission:response-template-delete')->name('response_templates.destroy');
    Route::patch('/response_templates/{response_template}/toggle-status', [ResponseTemplateController::class, 'toggleStatus'])->middleware('permission:response-template-enable-disable')->name('response_templates.toggle-status');
    Route::patch('response_templates/restore/{id}', [ResponseTemplateController::class, 'restore'])->middleware('permission:response-template-delete')->name('response_templates.restore');


    // Channels
    Route::get('/channels/enabled', [ChannelController::class, 'enabledChannels'])->middleware('permission:channel-enable-disable')->name('channels.enabled');
    Route::get('/channels/disabled', [ChannelController::class, 'disabledChannels'])->middleware('permission:channel-enable-disable')->name('channels.disabled');
    Route::get('channels/trashed', [ChannelController::class, 'trashed'])->middleware('permission:channel-delete')->name('channels.trashed');
    Route::resource('channels', ChannelController::class)->middleware('permission:channel-list');
    Route::get('/channels/create', [ChannelController::class, 'create'])->middleware('permission:channel-add')->name('channels.create');
    Route::get('/channels/{channel}/edit', [ChannelController::class, 'edit'])->middleware('permission:channel-edit')->name('channels.edit');
    Route::delete('/channels/{channel}', [ChannelController::class, 'destroy'])->middleware('permission:channel-delete')->name('channels.destroy');
    Route::post('channels/restore/{id}', [ChannelController::class, 'restore'])->middleware('permission:channel-delete')->name('channels.restore');
    Route::delete('channels/force-delete/{id}', [ChannelController::class, 'forceDelete'])->middleware('permission:channel-delete')->name('channels.force-delete');
    Route::patch('/channels/{channel}/toggle-status', [ChannelController::class, 'toggleStatus'])->middleware('permission:channel-enable-disable')->name('channels.toggle-status');

    // Channel Commission
    Route::resource('channel_commissions', ChannelCommissionController::class)->middleware('permission:channel-commission');

    // Tour Setting
    Route::post('/import-tour', [TourSettingController::class, 'importTour'])->middleware('permission:tour-import')->name('tour_settings.importTour');
    Route::get('/tour/published', [TourSettingController::class, 'publishedTours'])->middleware('permission:tour-published-unpublished')->name('tour_settings.published');
    Route::get('/tour/unpublished', [TourSettingController::class, 'unpublishedTours'])->middleware('permission:tour-published-unpublished')->name('tour_settings.unpublished');
    Route::get('tours/trashed', [TourSettingController::class, 'trashed'])->middleware('permission:tour-delete')->name('tour_settings.trashed');
    Route::resource('tour_settings', TourSettingController::class)->middleware('permission:tour-list');
    Route::get('/tour_settings/{tour_setting}/edit', [TourSettingController::class, 'edit'])->middleware('permission:tour-edit')->name('tour_settings.edit');
    Route::delete('/tour_settings/{tour_setting}', [TourSettingController::class, 'destroy'])->middleware('permission:tour-delete')->name('tour_settings.destroy');
    Route::post('tours/restore/{id}', [TourSettingController::class, 'restore'])->middleware('permission:tour-delete')->name('tour_settings.restore');
    Route::delete('tours/force-delete/{id}', [TourSettingController::class, 'forceDelete'])->middleware('permission:tour-delete')->name('tour_settings.force-delete');
    Route::patch('/tours/{tour}/toggle-status', [TourSettingController::class, 'toggleStatus'])->middleware('permission:tour-published-unpublished')->name('tour_settings.toggle-status');

    //Tour Guide
    Route::get('/tour-guides/search', [TourGuideController::class, 'search'])->name('tour-guides.search');
    Route::resource('/tour-guides', TourGuideController::class);
    Route::post('/tour-guides/interviewed/{id}', [TourGuideController::class, 'switchToInterviewed'])->name('tour-guides.interview');
    Route::post('/tour-guides/active/{id}', [TourGuideController::class, 'makeActiveUser'])->name('tour-guides.active');
    Route::post('/tour-guides/decline/{id}', [TourGuideController::class, 'declineTourGuide'])->name('tour-guides.decline');
    Route::post('/tour-guides/reject/{id}', [TourGuideController::class, 'rejectTourGuide'])->name('tour-guides.reject');
    Route::post('/tour-guides/send-contract-mail', [TourGuideController::class, 'sendContractMail'])->name('tour-guides.send-contract-mail');
    Route::post('/tour-guides/login-without-password', [TourGuideController::class, 'loginWithoutPassword'])->name('tour-guides.login-without-password');
    Route::post('/tour-guides/Send-reset-password', [TourGuideController::class, 'sendResetPassword'])->name('tour-guides.send-reset-password');

});


require __DIR__.'/auth.php';

