<x-admin-layout>
    <x-slot name="header">
        <h1 class="text-2xl font-bold">Tours List</h1>
    </x-slot>
    <x-message type="success" message="success" />
    <x-message type="danger" message="error" />
    <div class="mb-4 flex justify-between items-center">
        @can('tour-published-unpublished')
        <div>
            <a href="{{ route('admin.tour_settings.published') }}" class="inline-flex items-center px-4 py-2 text-xs font-semibold tracking-widest uppercase border border-transparent rounded-md shadow-sm
            {{ request()->routeIs('admin.tour_settings.unpublished') ? 'bg-gray-300 text-black hover:bg-gray-400' : 'bg-blue-600 text-white hover:bg-blue-700' }}">
            View Published Tours
            </a>
            <a href="{{ route('admin.tour_settings.unpublished') }}" class="inline-flex items-center px-4 py-2 text-xs font-semibold tracking-widest uppercase border border-transparent rounded-md shadow-sm
                {{ request()->routeIs('admin.tour_settings.unpublished') ? 'bg-gray-600 text-white hover:bg-gray-700' : 'bg-gray-300 text-black hover:bg-gray-400' }}">
                View Unpublished Tours
            </a>
        </div>
        @endcan
        @can('tour-delete')
        <div>
            <a href="{{ route('admin.tour_settings.trashed') }}" class="inline-flex items-center px-4 py-2 text-xs font-semibold tracking-widest text-white uppercase bg-red-600 rounded-md shadow-sm hover:bg-red-700">
                View Trashed Tours
            </a>
        </div>
        @endcan
    </div>

    <div class="p-6 bg-white rounded-lg shadow-md dark:bg-gray-800">
        <!-- Desktop View -->
        <div class="hidden md:block">
            <div class="flex items-center justify-between mb-4">
                @can('tour-import')
                @include('admin.tour_setting.bokun-model')
                @endcan
            </div>

            <!-- Scrollable Table Container -->
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                    <thead class="bg-gray-50 dark:bg-gray-800">
                        <tr>
                            {{-- <th class="px-4 py-3 text-xs font-medium text-left text-gray-500 uppercase dark:text-gray-400">Status</th> --}}
                            <th class="px-4 py-3 text-xs font-medium text-left text-gray-500 uppercase dark:text-gray-400">Bokun ID</th>
                            <th class="px-4 py-3 text-xs font-medium text-left text-gray-500 uppercase dark:text-gray-400">Bokun Title</th>
                            <th class="px-4 py-3 text-xs font-medium text-left text-gray-500 uppercase dark:text-gray-400">Tour Name</th>
                            <th class="px-4 py-3 text-xs font-medium text-left text-gray-500 uppercase dark:text-gray-400">Response Template</th>
                            <th class="px-4 py-3 text-xs font-medium text-left text-gray-500 uppercase dark:text-gray-400">Time</th>
                            <th class="px-4 py-3 text-xs font-medium text-left text-gray-500 uppercase dark:text-gray-400">Guide Fee</th>
                            <th class="px-4 py-3 text-xs font-medium text-left text-gray-500 uppercase dark:text-gray-400">Duration</th>
                            <th class="px-4 py-3 text-xs font-medium text-left text-gray-500 uppercase dark:text-gray-400">City</th>
                            <th class="px-4 py-3 text-xs font-medium text-left text-gray-500 uppercase dark:text-gray-400">Tour Type</th>
                            <th class="px-4 py-3 text-xs font-medium text-left text-gray-500 uppercase dark:text-gray-400">Manager</th>
                            <th class="px-4 py-3 text-xs font-medium text-left text-gray-500 uppercase dark:text-gray-400 text-center">Action</th>
                        </tr>
                    </thead>
                    <tbody id="userTable" class="bg-white divide-y divide-gray-200 dark:bg-gray-900 dark:divide-gray-700">
                        @forelse($tours as $tour)
                        <tr>
                            {{-- <td class="px-4 py-3 text-sm font-medium text-gray-900 dark:text-gray-100">{{ $tour->status == 1 ? 'Published' : 'Unpublished' }}</td> --}}
                            <td class="px-4 py-3 text-sm font-medium text-gray-900 dark:text-gray-100">{{ $tour->bokun_id }}</td>
                            <td class="px-4 py-3 text-sm font-medium text-gray-900 dark:text-gray-100">{{ $tour->bokun_title }}</td>
                            <td class="px-4 py-3 text-sm font-medium text-gray-900 dark:text-gray-100">{{ $tour->name }}</td>
                            <td class="px-4 py-3 text-sm font-medium text-gray-900 dark:text-gray-100">{{ $tour->groups->pluck('name')->implode(', ') }}</td>
                            <td class="px-4 py-3 text-sm font-medium text-gray-900 dark:text-gray-100">{{ $tour->time }}</td>
                            <td class="px-4 py-3 text-sm font-medium text-gray-900 dark:text-gray-100">{{ $tour->guide_free }}</td>
                            <td class="px-4 py-3 text-sm font-medium text-gray-900 dark:text-gray-100">{{ $tour->duration }}</td>
                            <td class="px-4 py-3 text-sm font-medium text-gray-900 dark:text-gray-100">{{ $tour->city->eng_name ?? 'N/A' }}</td>
                            <td class="px-4 py-3 text-sm font-medium text-gray-900 dark:text-gray-100">{{ $tour->tourTypes->pluck('name')->implode(', ') }}</td>
                            <td class="px-4 py-3 text-sm font-medium text-gray-900 dark:text-gray-100">{{ $tour->managers->pluck('name')->join(', ') }}</td>
                            <td class="px-4 py-3 text-sm font-medium whitespace-nowrap">
                                <a href="{{ route('admin.tour_settings.show', $tour) }}" class="text-indigo-600 dark:text-indigo-400 hover:text-indigo-900 dark:hover:text-indigo-300">View</a>
                                @if($tour->status)
                                @can('tour-edit')
                                <a href="{{ route('admin.tour_settings.edit', $tour) }}" class="ml-4 text-indigo-600 dark:text-indigo-400 hover:text-indigo-900 dark:hover:text-indigo-300">Edit</a>
                                @endcan
                                @can('tour-delete')
                                <button type="button" class="inline ml-4 text-red-600 dark:text-red-400 hover:text-red-900 dark:hover:text-red-300" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $tour->id }}">
                                    Delete
                                </button>
                                <x-delete-modal :type="'tour'" :id="$tour->id" :name="$tour->name" route="admin.tour_settings.destroy" />
                                @endcan
                                @endif
                                @can('tour-published-unpublished')
                                <button type="button" class="ml-4 px-3 py-1 text-white text-xs font-semibold rounded-md {{ $tour->status ? 'bg-green-500 hover:bg-green-600' : 'bg-gray-500 hover:bg-gray-600' }}" data-bs-toggle="modal" data-bs-target="#statusModal{{ $tour->id }}">
                                    {{ $tour->status ? 'Published' : 'Unpublished' }}
                                </button>
                                <x-status-modal :type="$tour->status ? 'Unpublished' : 'Published'" :id="$tour->id" :name="$tour->name" route="admin.tour_settings.toggle-status" />
                                @endcan
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="12" class="px-6 py-4 text-center text-gray-500 dark:text-gray-400">
                                No Tours found.
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="mt-4">
                {{ $tours->links() }}
            </div>
        </div>
    </div>
</x-admin-layout>
