<x-admin-layout>
    @include('admin.tour_guide.send_contract')
    @if (!empty($breadcrumbs))
        <x-breadcrumbs :items="$breadcrumbs" />
    @endif
    <x-message type="success" message="success" />
    <x-message type="danger" message="error" />

    <!-- Search Filters -->
    <div class="mb-4 bg-white p-4 shadow rounded-lg">
       <!-- Tour Guide Name with search icon -->
       <div class="relative mb-4">
            <input type="text" id="name" class="w-full py-1 pl-4 pr-12 rounded-md border border-gray-300 text-gray-700 text-sm placeholder-gray-400 focus:outline-none focus:ring-1 focus:ring-gray-800 focus:border-gray-800 transition duration-100" placeholder="{{ __('common.search_tour_guide_name')}}">
            <!-- Search icon inside input -->
            <div class="absolute inset-y-0 right-0 flex items-center px-4 pointer-events-none text-gray-400 p-2">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none"
                    viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M21 21l-4.35-4.35M16.65 16.65A7.5 7.5 0 1116.65 2.5a7.5 7.5 0 010 14.15z" />
                </svg>
            </div>
        </div>
        <hr class="my-3">
        {{-- <div class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-3 gap-3"> --}}
        <div class="flex flex-row gap-2 mb-2">
            <!-- Status -->
            <div class="flex flex-col sm:w-1/2 md:w-1/4">
                <label for="status" class="text-gray-600 text-sm font-medium mb-2">{{__('common.status')}}</label>
                <select id="status" class="p-1 rounded-md border border-gray-300 text-gray-700 text-sm placeholder-gray-400 focus:outline-none focus:ring-1 focus:ring-gray-800 focus:border-gray-800 transition duration-100">
                    <option value="" selected disabled>{{__('common.select_status')}}</option>
                    <option value="All">All</option>
                    <option value="0">Not Active</option>
                    <option value="1">Active</option>
                    <option value="2">Applied</option>
                    <option value="3">Interiewed</option>
                    <option value="4">Declined</option>
                    <option value="5">Rejected</option>
                </select>
            </div>

            <!-- Region -->
            <div class="flex flex-col w-full sm:w-1/2 md:w-1/4">
                <label for="region" class="text-gray-600 text-sm font-medium mb-2">{{__('common.region')}}</label>
                <select id="region" class="p-1 rounded-md border border-gray-300 text-gray-700 text-sm placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-gray-400 focus:border-gray-400 transition duration-100">
                    <option value="" selected disabled>{{__('common.select_a_region')}}</option>
                    @foreach($regions as $region)
                        <option value="{{ $region->id }}">{{ $region->eng_name }}</option>
                    @endforeach
                </select>
            </div>

            <!-- Prefecture -->
            <div class="flex flex-col w-full sm:w-1/2 md:w-1/4">
                <label for="prefecture" class="text-gray-600 text-sm font-medium mb-2">{{__('common.prefecture')}}</label>
                <select id="prefecture" class="p-1 rounded-md border border-gray-300 text-gray-700 text-sm placeholder-gray-400 focus:outline-none focus:ring-1 focus:ring-gray-800 focus:border-gray-800 transition duration-100">
                    <option value="" selected disabled>{{__('common.select_a_prefecture')}}</option>
                </select>
            </div>

            <!-- Position -->
            <div class="flex flex-col w-full sm:w-1/2 md:w-1/4">
                <label for="position" class="text-gray-600 text-sm font-medium mb-2">{{__('common.position')}}</label>
                <select id="position" class="p-1 rounded-md border border-gray-300 text-gray-700 text-sm placeholder-gray-400 focus:outline-none focus:ring-1 focus:ring-gray-800 focus:border-gray-800 transition duration-100">
                    <option value="" selected disabled>{{__('common.select_position')}}</option>
                    <option value="All">All</option>
                    <option value="Tour Guide">Tour Guide</option>
                    <option value="Tour Support">Tour Support</option>
                    <option value="Photographer">Photographer</option>
                </select>
            </div>

            <!-- Invoice Registration -->
            <div class="flex flex-col w-full sm:w-1/2 md:w-1/4">
                <label for="invoice" class="text-gray-600 text-sm font-medium mb-2">{{__('common.invoice_registration')}}</label>
                <select id="invoice" class="p-1 rounded-md border border-gray-300 text-gray-700 text-sm placeholder-gray-400 focus:outline-none focus:ring-1 focus:ring-gray-800 focus:border-gray-800 transition duration-100">
                    <option value="" selected disabled>{{__('common.invoice_registration')}}</option>
                    <option value="registered">Registered</option>
                    <option value="not_registered">Not Registered</option>
                </select>
            </div>
        </div>
        <!-- Reset Button -->
        <div class="">
            <button id="" class="mt-2 px-3 py-1 h-8 text-sm text-white rounded-md py-0" style="background-color: #2E8B57;">
                {{__('common.apply_filter')}}
            </button>
            <button id="resetFilters" class="text-sm font-semibold text-black bg-white">
                {{__('common.clear_all')}}
            </button>
        </div>
    </div>

    <!-- Table -->
    <div class="p-6 bg-white rounded-lg shadow-md">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead>
                    <tr>
                        <th class="px-1 py-3 text-center">
                            <input type="checkbox" id="selectAll" class="border-1 border-gray-400" style="border-radius: 5px"/>
                        </th>
                        <th class="px-2 py-3 text-xs font-medium text-left text-gray-500 dark:text-gray-400">
                            <div class="flex items-center justify-between">
                                {{__('common.status')}}
                                <a href="#">
                                    <svg width="8" height="10" viewBox="0 0 8 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1.42712 6.35451L4.00017 8.82257L6.57322 6.35451" stroke="#8A8C92" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M1.42712 3.64618L4.00017 1.17745L6.57322 3.64618" stroke="#8A8C92" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </a>
                            </div>

                        </th>
                        <th class="px-2 py-3 text-xs font-medium text-left text-gray-500 dark:text-gray-400">
                            <div class="flex items-center justify-between">
                                {{__('common.first_name')}}
                                <a href="#">
                                    <svg width="8" height="10" viewBox="0 0 8 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1.42712 6.35451L4.00017 8.82257L6.57322 6.35451" stroke="#8A8C92" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M1.42712 3.64618L4.00017 1.17745L6.57322 3.64618" stroke="#8A8C92" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round"/>
                                        </svg>
                                </a>
                            </div>
                        </th>
                        <th class="px-2 py-3 text-xs font-medium text-left text-gray-500 dark:text-gray-400">
                            <div class="flex items-center justify-between">
                                {{__('common.last_name')}}
                                <a href="#">
                                    <svg width="8" height="10" viewBox="0 0 8 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1.42712 6.35451L4.00017 8.82257L6.57322 6.35451" stroke="#8A8C92" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M1.42712 3.64618L4.00017 1.17745L6.57322 3.64618" stroke="#8A8C92" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round"/>
                                        </svg>
                                </a>
                            </div>
                        </th>
                        <th class="px-2 py-3 text-xs font-medium text-left text-gray-500 dark:text-gray-400">
                            <div class="flex items-center justify-between">
                                {{__('common.email')}}
                                <a href="#">
                                    <svg width="8" height="10" viewBox="0 0 8 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1.42712 6.35451L4.00017 8.82257L6.57322 6.35451" stroke="#8A8C92" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M1.42712 3.64618L4.00017 1.17745L6.57322 3.64618" stroke="#8A8C92" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round"/>
                                        </svg>
                                </a>
                            </div>
                        </th>
                        <th class="px-2 py-3 text-xs font-medium text-left text-gray-500 dark:text-gray-400">
                            <div class="flex items-center justify-between">
                                {{__('common.phone')}}
                                <a href="#">
                                    <svg width="8" height="10" viewBox="0 0 8 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1.42712 6.35451L4.00017 8.82257L6.57322 6.35451" stroke="#8A8C92" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M1.42712 3.64618L4.00017 1.17745L6.57322 3.64618" stroke="#8A8C92" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round"/>
                                        </svg>
                                </a>
                            </div>
                        </th>
                        <th class="px-2 py-3 text-xs font-medium text-left text-gray-500 dark:text-gray-400">
                            <div class="flex items-center justify-between">
                                {{__('common.region')}}
                                <a href="#">
                                    <svg width="8" height="10" viewBox="0 0 8 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1.42712 6.35451L4.00017 8.82257L6.57322 6.35451" stroke="#8A8C92" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M1.42712 3.64618L4.00017 1.17745L6.57322 3.64618" stroke="#8A8C92" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round"/>
                                        </svg>
                                </a>
                            </div>
                        </th>
                        <th class="px-2 py-3 text-xs font-medium text-left text-gray-500 dark:text-gray-400">
                            <div class="flex items-center justify-between">
                                {{__('common.prefecture')}}
                                <a href="#">
                                    <svg width="8" height="10" viewBox="0 0 8 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1.42712 6.35451L4.00017 8.82257L6.57322 6.35451" stroke="#8A8C92" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M1.42712 3.64618L4.00017 1.17745L6.57322 3.64618" stroke="#8A8C92" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round"/>
                                        </svg>
                                </a>
                            </div>
                        </th>
                        <th class="px-2 py-3 text-xs font-medium text-left text-gray-500 dark:text-gray-400">{{__('common.position')}}</th>
                        <th class="px-2 py-3"></th>
                    </tr>
                </thead>
                <tbody id="userTable">
                    @foreach($tour_guides as $guide)
                        <tr x-data="{ open: false, hovered: false }" @mouseenter="hovered = true" @mouseleave="hovered = false" class="border-b hover:bg-gray-50 transition">
                            <td class="px-2 py-3">
                                <input type="checkbox" class="guideCheckbox border-1 border-gray-300" style="border-radius: 5px" value="{{ $guide->id }}" />
                            </td>
                            <td class="px-2 py-3 text-sm font-medium text-gray-900 dark:text-gray-100">{{ $guide->status_text }}</td>
                            <td class="px-2 py-3 text-sm font-medium text-gray-900 dark:text-gray-100">{{ $guide->first_name }}</td>
                            <td class="px-2 py-3 text-sm font-medium text-gray-900 dark:text-gray-100">{{ $guide->last_name }}</td>
                            <td class="px-2 py-3 text-sm font-medium text-gray-900 dark:text-gray-100">{{ $guide->email }}</td>
                            <td class="px-2 py-3 text-sm font-medium text-gray-900 dark:text-gray-100">{{ $guide->phone }}</td>
                            <td class="px-2 py-3 text-sm font-medium text-gray-900 dark:text-gray-100">{{ $guide->region->eng_name ?? 'N/A' }}</td>
                            <td class="px-2 py-3 text-sm font-medium text-gray-900 dark:text-gray-100">{{ $guide->prefecture->eng_name ?? 'N/A' }}</td>
                            <td class="px-2 py-3 text-sm font-medium text-gray-900 dark:text-gray-100">{{ $guide->position }}</td>
                            <td class="relative">
                                <div class="relative">
                                    <!-- Three-dot button -->
                                    <button x-show="hovered" @click="open = !open" class="text-2xl font-bold text-gray-600 hover:text-gray-900 focus:outline-none transition-opacity">
                                        <i class="fas fa-ellipsis-v"></i>
                                    </button>
                                    <!-- Dropdown Menu -->
                                    <div x-show="open" @click.away="open = false" class="absolute right-0 mt-2 w-48 bg-white border rounded-lg shadow-lg z-10">
                                        <a href="/admin/tour-guides/{{ $guide->id }}" class="flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100">
                                            <i class="fas fa-eye mr-2"></i>&nbsp;
                                            View
                                        </a>
                                        <a href="{{route('admin.tour-guides.edit', $guide)}}" class="flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100">
                                            <i class="fas fa-edit mr-2"></i>&nbsp;
                                            Edit
                                        </a>
                                        @if($guide->status == 1)   <!-- Active -->
                                            <!-- Send Contract -->
                                            <button type="button" onclick="populateModal({{ json_encode($guide) }})"
                                                class="w-full text-left flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100"
                                                data-bs-toggle="modal" data-bs-target="#sendContractModal">
                                                <i class="fas fa-paper-plane"></i>&nbsp;
                                                Send Contract
                                            </button>
                                            <!-- Send Password Reset -->
                                            <form method="POST" action="{{ route('admin.tour-guides.send-reset-password') }}">
                                                @csrf
                                                <input type="hidden" name="email" value="{{ $guide->email }}">
                                                <button type="submit" class="w-full text-left flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100">
                                                    <i class="fas fa-key"></i>&nbsp; Send Password Reset
                                                </button>
                                            </form>
                                            <!-- Login Without Password -->
                                            <form method="POST" action="{{ route('admin.tour-guides.login-without-password') }}">
                                                @csrf
                                                <input type="hidden" name="email" value="{{ $guide->email }}">
                                                <button type="submit" class="w-full text-left flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100">
                                                    <i class="fas fa-lock"></i>&nbsp; Login Without Password
                                                </button>
                                            </form>

                                        @elseif ($guide->status == 2)   <!-- Applied -->
                                            <form action="{{ route('admin.tour-guides.interview', $guide->id) }}" method="POST">
                                                @csrf
                                                <button type="submit"
                                                    class="w-full text-left flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100"
                                                    onclick="return confirm('Are you sure you want to switch to Interviewed?');">
                                                    <i class="fas fa-user-check mr-2"></i>&nbsp;
                                                    Switch to Interviewed
                                                </button>
                                            </form>
                                        @elseif ($guide->status == 3)  <!-- Interviewed -->
                                            <button type="button" onclick="populateModal({{ json_encode($guide) }})"
                                                class="w-full text-left flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100"
                                                data-bs-toggle="modal" data-bs-target="#sendContractModal">
                                                <i class="fas fa-paper-plane"></i>&nbsp;
                                                Send Contract
                                            </button>
                                            <form action="{{ route('admin.tour-guides.active', $guide->id) }}" method="POST">
                                                @csrf
                                                <button type="submit"
                                                    class="w-full text-left flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100"
                                                    onclick="return confirm('Are you sure you want to activate this tour guide?');">
                                                    <i class="fas fa-user-plus mr-2"></i>&nbsp;
                                                    Make Active User
                                                </button>
                                            </form>
                                            <form action="{{ route('admin.tour-guides.reject', $guide->id) }}" method="POST">
                                                @csrf
                                                <button type="submit"
                                                    class="w-full text-left flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100"
                                                    onclick="return confirm('Are you sure you want to reject this tour guide?');">
                                                    <i class="fas fa-user-slash mr-2"></i>&nbsp;
                                                    JA Reject
                                                </button>
                                            </form>
                                            <form action="{{ route('admin.tour-guides.decline', $guide->id) }}" method="POST">
                                                @csrf
                                                <button type="submit"
                                                    class="w-full text-left flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100"
                                                    onclick="return confirm('Are you sure you want to decline this tour guide?');">
                                                    <i class="fas fa-user-times mr-2"></i>&nbsp;
                                                    TG Decline
                                                </button>
                                            </form>

                                            <button type="button" class="w-full text-left flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $guide->id }}">
                                                <i class="fas fa-trash mr-2"></i>&nbsp;
                                                Delete
                                            </button>
                                            <x-delete-modal :type="'Tour Guide'" :id="$guide->id" :name="$guide->first_name . ' ' . $guide->last_name" route="admin.tour-guides.destroy" />

                                        @elseif ($guide->status == 4)  <!-- Decline -->
                                            <form action="{{ route('admin.tour-guides.interview', $guide->id) }}" method="POST">
                                                @csrf
                                                <button type="submit"
                                                    class="w-full text-left flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100"
                                                    onclick="return confirm('Are you sure you want to switch to Interviewed?');">
                                                    <i class="fas fa-user-check mr-2"></i>&nbsp;
                                                    Switch to Interviewed
                                                </button>
                                            </form>
                                            <button type="button" class="w-full text-left flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $guide->id }}">
                                                <i class="fas fa-trash mr-2"></i>&nbsp;
                                                Delete
                                            </button>
                                            <x-delete-modal :type="'Tour Guide'" :id="$guide->id" :name="$guide->first_name . ' ' . $guide->last_name" route="admin.tour-guides.destroy" />
                                        @endif
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="mt-4">
                {{ $tour_guides->links('vendor.pagination.tailwind', ['perPage' => $perPage]) }}
            </div>
        </div>
    </div>
    <script>
        $(document).ready(function () {
            $("#selectAll").change(function () {
                $(".guideCheckbox").prop("checked", $(this).prop("checked"));
            });

            function fetchData() {
                let status = $('#status').val();
                let region = $('#region').val();
                let prefecture = $('#prefecture').val();
                let city = $('#city').val();
                let name = $('#name').val();
                let position = $('#position').val();
                let invoice = $('#invoice').val();

                $.ajax({
                    url: "/admin/tour-guides/search",
                    type: 'GET',
                    data: {
                        status: status,
                        region: region,
                        prefecture: prefecture,
                        city: city,
                        name: name,
                        position: position,
                        invoice: invoice
                    },
                    success: function (data) {

                        $('#userTable').html('');
                        data.forEach(function (guide) {
                            $('#userTable').append(`
                                <tr>
                                    <td class="px-2 py-3 text-sm font-medium text-gray-900 dark:text-gray-100 text-center">
                                        <input type="checkbox" class="guideCheckbox" value="${guide.id}" />
                                    </td>
                                    <td class="px-2 py-3 text-sm font-medium text-gray-900 dark:text-gray-100 text-center">${guide.status_text}</td>
                                    <td class="px-2 py-3 text-sm font-medium text-gray-900 dark:text-gray-100 text-center">${guide.first_name}</td>
                                    <td class="px-2 py-3 text-sm font-medium text-gray-900 dark:text-gray-100 text-center">${guide.last_name}</td>
                                    <td class="px-2 py-3 text-sm font-medium text-gray-900 dark:text-gray-100 text-center">${guide.email}</td>
                                    <td class="px-2 py-3 text-sm font-medium text-gray-900 dark:text-gray-100 text-center">${guide.phone}</td>
                                    <td class="px-2 py-3 text-sm font-medium text-gray-900 dark:text-gray-100 text-center">${guide.region?.eng_name || "N/A"}</td>
                                    <td class="px-2 py-3 text-sm font-medium text-gray-900 dark:text-gray-100 text-center">${guide.prefecture?.eng_name || "N/A"}</td>
                                    <td class="px-2 py-3 text-sm font-medium text-gray-900 dark:text-gray-100 text-center">${guide.city?.eng_name || "N/A"}</td>
                                    <td class="px-2 py-3 text-sm font-medium text-gray-900 dark:text-gray-100 text-center">${guide.position}</td>
                                    <td class="px-2 py-3 text-sm font-medium text-gray-900 dark:text-gray-100 text-center relative">
                                        <div x-data="{ open: false }" class="relative">
                                            <button @click="open = !open" class="text-2xl font-bold text-gray-600 hover:text-gray-900 focus:outline-none">
                                                <i class="fas fa-ellipsis-v"></i>
                                            </button>
                                            <div x-show="open" @click.away="open = false" class="absolute right-0 mt-2 w-48 bg-white border rounded-lg shadow-lg z-10">
                                                <a href="/admin/tour-guides/${guide.id}" class="flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100">
                                                    <i class="fas fa-eye mr-2"></i>&nbsp; View
                                                </a>
                                                <a href="/admin/tour-guides/${guide.id}/edit" class="flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100">
                                                    <i class="fas fa-edit mr-2"></i>&nbsp; Edit
                                                </a>
                                                ${guide.status == 1 ? `
                                                    <button type="button" onclick="populateModal(${JSON.stringify(guide)})"
                                                        class="w-full text-left flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100"
                                                        data-bs-toggle="modal" data-bs-target="#sendContractModal">
                                                        <i class="fas fa-paper-plane"></i>&nbsp; Send Contract
                                                    </button>
                                                    <form method="POST" action="/admin/tour-guides/send-reset-password">
                                                        <input type="hidden" name="email" value="${guide.email}">
                                                        <button type="submit" class="w-full text-left flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100">
                                                            <i class="fas fa-key"></i>&nbsp; Send Password Reset
                                                        </button>
                                                    </form>
                                                    <form method="POST" action="/admin/tour-guides/login-without-password">
                                                        <input type="hidden" name="email" value="${guide.email}">
                                                        <button type="submit" class="w-full text-left flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100">
                                                            <i class="fas fa-lock"></i>&nbsp; Login Without Password
                                                        </button>
                                                    </form>
                                                ` : ''}
                                               ${guide.status == 2 ? `
                                                    <form action="/admin/tour-guides/interview/${guide.id}" method="POST">
                                                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                                        <button type="submit" class="w-full text-left flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100"
                                                            onclick="return confirm('Are you sure you want to switch to Interviewed?');">
                                                            <i class="fas fa-user-check mr-2"></i>&nbsp; Switch to Interviewed
                                                        </button>
                                                    </form>
                                                ` : ''}

                                               ${guide.status == 3 ? `
                                                    <button type="button" onclick="populateModal(${JSON.stringify(guide)})"
                                                        class="w-full text-left flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100"
                                                        data-bs-toggle="modal" data-bs-target="#sendContractModal">
                                                        <i class="fas fa-paper-plane"></i>&nbsp; Send Contract
                                                    </button>
                                                    <form action="/admin/tour-guides/active/${guide.id}" method="POST">
                                                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                                        <button type="submit" class="w-full text-left flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100"
                                                            onclick="return confirm('Are you sure you want to activate this tour guide?');">
                                                            <i class="fas fa-user-plus mr-2"></i>&nbsp; Make Active User
                                                        </button>
                                                    </form>
                                                    <form action="/admin/tour-guides/reject/${guide.id}" method="POST">
                                                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                                        <button type="submit" class="w-full text-left flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100"
                                                            onclick="return confirm('Are you sure you want to reject this tour guide?');">
                                                            <i class="fas fa-user-slash mr-2"></i>&nbsp; JA Reject
                                                        </button>
                                                    </form>
                                                    <form action="/admin/tour-guides/decline/${guide.id}" method="POST">
                                                        @csrf
                                                        <button type="submit"
                                                            class="w-full text-left flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100"
                                                            onclick="return confirm('Are you sure you want to decline this tour guide?');">
                                                            <i class="fas fa-user-times mr-2"></i>&nbsp; TG Decline
                                                        </button>
                                                    </form>
                                                    <button type="button" class="w-full text-left flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100" data-bs-toggle="modal" data-bs-target="#deleteModal${guide.id}">
                                                        <i class="fas fa-trash mr-2"></i>&nbsp; Delete
                                                    </button>
                                                ` : ''}

                                                ${guide.status == 4 ? `
                                                    <form action="/admin/tour-guides/interview/${guide.id}" method="POST">
                                                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                                        <button type="submit" class="w-full text-left flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100"
                                                            onclick="return confirm('Are you sure you want to switch to Interviewed?');">
                                                            <i class="fas fa-user-check mr-2"></i>&nbsp; Switch to Interviewed
                                                        </button>
                                                    </form>
                                                    <button type="button" class="w-full text-left flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100" data-bs-toggle="modal" data-bs-target="#deleteModal${guide.id}">
                                                        <i class="fas fa-trash mr-2"></i>&nbsp; Delete
                                                    </button>
                                                ` : ''}
                                            </div>
                                        </div>
                                    </td>

                                </tr>
                            `);
                        });
                        setTimeout(() => {
                            Alpine.initTree(document.body);
                        }, 100);
                    }
                });
            }

            // Filter Events
            $('#status, #region, #prefecture, #city, #name, #position, #invoice').on('change keyup', function () {
                fetchData();
            });

            $('#region').change(function () {
                let regionId = $(this).val();
                if (!regionId) {
                    $('#prefecture').html('<option value="">Please select a prefecture</option>');
                    return;
                }

                $.get("{{ route('get.prefectures') }}?region_id=" + regionId, function (data) {
                    $('#prefecture').html('<option value="">Please select a prefecture</option>');
                    data.forEach(pref => {
                        $('#prefecture').append(`<option value="${pref.id}">${pref.eng_name}</option>`);
                    });
                });
            });

            $('#prefecture').change(function () {
                let prefectureId = $(this).val();
                if (!prefectureId) {
                    $('#city').html('<option value="">Please select a city</option>');
                    return;
                }

                $.get("{{ route('get.cities') }}?prefecture_id=" + prefectureId, function (data) {
                    $('#city').html('<option value="">Please select a city</option>');
                    data.forEach(city => {
                        $('#city').append(`<option value="${city.id}">${city.eng_name}</option>`);
                    });
                });
            });

            // Reset Filters
            $('#resetFilters').click(function () {
                resetFilters();
                fetchData();
            });
        });
        function resetFilters() {
            $('#status, #region, #prefecture, #city, #name, #position, #invoice').val('');
        }
        document.addEventListener("DOMContentLoaded", function() {
            setInterval(() => {
                document.querySelectorAll('.modal-backdrop').forEach(backdrop => {
                    backdrop.style.display = 'none'; // Hide forcibly
                    backdrop.classList.remove('show'); // Remove 'show' class if applied
                });
                document.body.classList.remove('modal-open'); // Body scrolling enable
            }, 500);
        });
        window.onload = resetFilters;
        window.onload = fetchData;
    </script>
</x-admin-layout>
