<x-admin-layout>
    <x-slot name="header">
        <h1 class="text-2xl font-bold">Role Details</h1>
    </x-slot>

    <div class="flex justify-center">
        <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-lg w-full max-w-4xl">

            <!-- Role Name Section -->
            <div class="bg-gray-100 dark:bg-gray-700 p-4 rounded-lg shadow-md mb-6 text-center">
                <h2 class="text-2xl font-bold text-gray-900 dark:text-gray-100 uppercase">
                    {{ $role->name }}
                </h2>
            </div>

            <!-- Permissions Heading -->
            <h3 class="text-xl font-semibold text-gray-900 dark:text-gray-100 mb-3">Permissions</h3>

            <!-- Permissions Section (Module Wise) -->
            @php
                $groupedPermissions = $role->permissions->groupBy(function ($permission) {
                    return explode('-', $permission->name)[0]; // Extract module name
                });
            @endphp

            <div class="grid grid-cols-2 gap-4">
                @foreach ($groupedPermissions as $module => $permissions)
                    <div class="bg-gray-100 dark:bg-gray-700 p-4 rounded-lg shadow-md">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100 capitalize">
                            {{ $module }}
                        </h3>
                        <div class="mt-2 space-y-1">
                            @foreach ($permissions as $permission)
                                <p class="text-gray-700 dark:text-gray-300">{{ $permission->name }}</p>
                            @endforeach
                        </div>
                    </div>
                @endforeach
            </div>

            <!-- Action Buttons -->
            <div class="flex items-center justify-end space-x-4 mt-6">
                <a href="{{ route('admin.roles.edit', $role) }}"
                   class="bg-blue-500 text-white px-4 py-2 rounded-md shadow-md hover:bg-blue-600">
                    Edit Role
                </a>
                <form action="{{ route('admin.roles.destroy', $role) }}" method="POST"
                      onsubmit="return confirm('Are you sure you want to delete this role?');">
                    @csrf
                    @method('DELETE')
                    <button type="submit"
                            class="bg-red-500 text-white px-4 py-2 rounded-md shadow-md hover:bg-red-600">
                        Delete Role
                    </button>
                </form>
            </div>

        </div>
    </div>
</x-admin-layout>
