<x-admin-layout>
    <x-slot name="header">
        <h1 class="text-2xl font-bold">Roles</h1>
    </x-slot>

    <div class="p-6 bg-white rounded-lg shadow-md dark:bg-gray-800">
        <form method="POST" action="{{ route('admin.roles.store') }}">
            @csrf

            <!-- Role Name -->
            <div class="mb-4">
                <label for="role_name" class="block text-gray-700 font-bold">Role Name</label>
                <input type="text" name="name" id="role_name" class="w-full px-3 py-2 border rounded-lg" required>
            </div>

            <!-- Permissions Heading -->
            <h3 class="text-lg font-semibold mb-4">Permissions</h3>

            <!-- Permissions Grid (2 Cards per Row) -->
            <div class="grid grid-cols-2 gap-4">
                @foreach ($modules as $module => $permissions)
                    <div class="bg-gray-100 dark:bg-gray-700 p-4 rounded-lg shadow-md">

                        <!-- Module Checkbox -->
                        <div class="flex items-center mb-3">
                            <input type="checkbox" id="module-{{ $module }}"
                                onclick="toggleModule('{{ $module }}')">
                            <label for="module-{{ $module }}" class="font-bold ml-2 text-lg capitalize">
                                {{ $module }}
                            </label>
                        </div>

                        <!-- Permissions List -->
                        <div class="space-y-1">
                            @foreach ($permissions as $permission)
                                <div class="flex items-center p-1">
                                    <input type="checkbox" name="permissions[]" value="{{ $permission->id }}"
                                        class="{{ $module }}-permission">
                                    <label class="ml-2 text-sm">{{ $permission->name }}</label>
                                </div>
                            @endforeach
                        </div>

                    </div>
                @endforeach
            </div>

            <!-- Submit Button -->
            <div class="flex items-center justify-end mt-6">
                <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded-md shadow-md hover:bg-blue-600">
                    Save Role
                </button>
            </div>
        </form>
    </div>

    <script>
        function toggleModule(module) {
            let moduleCheckbox = document.getElementById('module-' + module);
            let permissionCheckboxes = document.querySelectorAll('.' + module + '-permission');

            permissionCheckboxes.forEach(checkbox => {
                checkbox.checked = moduleCheckbox.checked;
            });
        }
    </script>
</x-admin-layout>
