<x-admin-layout>
    <x-slot name="header">
        <h1 class="text-2xl font-bold">Channel Commission List</h1>
    </x-slot>

    <x-message type="success" message="success" />
    <x-message type="danger" message="error" />

    <form id="commissionForm" action="{{ route('admin.channel_commissions.store') }}" method="POST">
        @csrf
        <input type="hidden" name="deleted_commissions" id="deleted_commissions">
        <input type="hidden" name="deleted_tour_exceptions" id="deleted_tour_exceptions">
        <div class="p-6">
            <div id="container" class="space-y-4">
                @if($channelCommissions->isNotEmpty())
                    @foreach($channelCommissions as $index => $commission)
                        <div class="bg-gray-200 p-4 rounded-md shadow relative channel-commission" data-index="{{ $index }}" data-id="{{ $commission->id ?? '' }}">
                            <div class="flex items-center mt-2">
                                <span class="bg-gray-700 text-white px-3 py-2">Default</span>
                                <select name="channels[]" class="channel-select block w-full border border-gray-300 shadow-sm">
                                    @foreach($channels as $channel)
                                        <option value="{{ $channel->id }}" {{ $commission->channel_id == $channel->id ? 'selected' : '' }}>
                                            {{ $channel->name }}
                                        </option>
                                    @endforeach
                                </select>
                                <input type="number" name="commissions[]" class="ml-4 px-2 py-2 border rounded-md commission-input"
                                    placeholder="Commission" value="{{ $commission->commission }}">
                                <button type="button" class="ml-4 bg-red-500 text-white px-3 py-2 rounded-md" onclick="removeCommission(this)">-</button>
                            </div>

                            <div class="mt-3 space-y-2 tour-exceptions">
                                @foreach($commission->tourExceptions as $tourException)
                                <div class="bg-gray-300 p-3 rounded-md mt-2 flex items-center gap-x-4 tour-exception" data-id="{{ $tourException->id ?? '' }}">
                                    <span class="font-medium whitespace-nowrap">Tour Exception</span>
                                    <select name="tours[{{ $index }}][]" class="tour-select ml-4 w-full border border-gray-300 shadow-sm rounded-md px-2 py-1">
                                        @foreach($tours as $tour)
                                            <option value="{{ $tour->id }}" {{ $tourException->tour_id == $tour->id ? 'selected' : '' }}>
                                                {{ $tour->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <input type="number" name="tour_commissions[{{ $index }}][]" class="ml-4 border border-gray-300 shadow-sm rounded-md px-2 py-1 w-32"
                                        placeholder="Commission" value="{{ $tourException->commission }}">
                                    <button type="button" class="ml-4 bg-red-500 text-white px-3 py-1 rounded-md" onclick="removeTourException(this)">-</button>
                                </div>
                                @endforeach
                            </div>

                            <button type="button" class="bg-green-500 text-white px-3 py-1 mt-2 rounded-md" onclick="addTourException(this)">+ Add Tour Exception</button>
                        </div>
                    @endforeach
                @else
                    <!-- Default Div Jab Data Na Ho -->
                    <div class="bg-gray-200 p-4 rounded-md shadow relative channel-commission" data-index="0">
                        <div class="flex items-center mt-2">
                            <span class="bg-gray-700 text-white px-3 py-2">Default</span>
                            <select name="channels[]" class="channel-select block w-full border border-gray-300 shadow-sm">
                                @foreach($channels as $channel)
                                    <option value="{{ $channel->id }}">{{ $channel->name }}</option>
                                @endforeach
                            </select>
                            <input type="number" name="commissions[]" class="ml-4 px-2 py-2 border rounded-md commission-input" placeholder="Commission">
                            <button type="button" class="ml-4 bg-red-500 text-white px-3 py-2 rounded-md" onclick="this.closest('.channel-commission').remove()">-</button>
                        </div>
                        <div class="mt-3 space-y-2 tour-exceptions"></div>
                        <button type="button" class="bg-green-500 text-white px-3 py-1 mt-2 rounded-md" onclick="addTourException(this)">+ Add Tour Exception</button>
                    </div>
                @endif
            </div>


            <div class="mt-4">
                <button type="button" class="bg-gray-700 text-white px-3 py-1 rounded-md" onclick="addDefaultSection()">
                    <span class="text-lg">+</span>
                </button>
            </div>

            <div class="flex items-center justify-end">
                <button type="submit" class="inline-flex items-center px-4 py-2 text-xs font-semibold tracking-widest text-white uppercase bg-indigo-600 border border-transparent rounded-md shadow-sm hover:bg-indigo-700">
                    Save
                </button>
            </div>
        </div>
    </form>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            function addDefaultSection() {
                const container = document.getElementById('container');
                const totalSections = document.querySelectorAll('.channel-commission').length;

                const defaultSection = document.createElement('div');
                defaultSection.classList.add("bg-gray-200", "p-4", "rounded-md", "shadow", "relative", "channel-commission");
                defaultSection.dataset.index = totalSections;

                defaultSection.innerHTML = `
                    <div class="flex items-center mt-2">
                        <span class="bg-gray-700 text-white px-3 py-2">Default</span>
                        <select name="channels[]" class="channel-select block w-full border border-gray-300 shadow-sm">
                            @foreach($channels as $channel)
                                <option value="{{ $channel->id }}">{{ $channel->name }}</option>
                            @endforeach
                        </select>
                        <input type="number" name="commissions[]" class="ml-4 px-2 py-2 border rounded-md commission-input" placeholder="Commission">
                        <button type="button" class="ml-4 bg-red-500 text-white px-3 py-2 rounded-md" onclick="removeCommission(this, '{{ $commission->id ?? '' }}">-</button>
                    </div>
                    <div class="mt-3 space-y-2 tour-exceptions"></div>
                    <button type="button" class="bg-green-500 text-white px-3 py-1 mt-2 rounded-md" onclick="addTourException(this)">+ Add Tour Exception</button>
                `;

                container.appendChild(defaultSection);
            }

            function addTourException(button) {
                const tourContainer = button.previousElementSibling;
                const parentSection = button.closest('.channel-commission');

                if (!parentSection.dataset.index) {
                    const allSections = document.querySelectorAll('.channel-commission');
                    parentSection.dataset.index = Array.from(allSections).indexOf(parentSection);
                }

                let parentIndex = parentSection.dataset.index;
                const tourException = document.createElement('div');
                tourException.classList.add("bg-gray-300", "p-3", "rounded-md", "mt-2", "flex", "items-center", "gap-x-4");

                tourException.innerHTML = `
                    <span class="font-medium whitespace-nowrap">Tour Exception</span>
                    <select name="tours[${parentIndex}][]" class="tour-select ml-4 w-full border border-gray-300 shadow-sm rounded-md px-2 py-1">
                        @foreach($tours as $tour)
                            <option value="{{ $tour->id }}">{{ $tour->name }}</option>
                        @endforeach
                    </select>
                    <input type="number" name="tour_commissions[${parentIndex}][]" class="ml-4 border border-gray-300 shadow-sm rounded-md px-2 py-1 w-32" placeholder="Commission">
                    <button type="button" class="ml-4 bg-red-500 text-white px-3 py-1 rounded-md" onclick="this.parentElement.remove()">-</button>
                `;

                tourContainer.appendChild(tourException);
            }

            function removeCommission(button) {
                const commissionElement = button.closest('.channel-commission');
                const commissionId = commissionElement.dataset.id;
                if (commissionId) {
                    let deletedCommissions = document.getElementById('deleted_commissions').value;
                    deletedCommissions += deletedCommissions ? `,${commissionId}` : commissionId;
                    document.getElementById('deleted_commissions').value = deletedCommissions;
                }
                commissionElement.remove();
            }

            function removeTourException(button) {
                const tourExceptionElement = button.closest('.tour-exception');
                const tourExceptionId = tourExceptionElement.dataset.id;
                if (tourExceptionId) {
                    let deletedTourExceptions = document.getElementById('deleted_tour_exceptions').value;
                    deletedTourExceptions += deletedTourExceptions ? `,${tourExceptionId}` : tourExceptionId;
                    document.getElementById('deleted_tour_exceptions').value = deletedTourExceptions;
                }
                tourExceptionElement.remove();
            }


            window.addDefaultSection = addDefaultSection;
            window.addTourException = addTourException;
            window.removeCommission = removeCommission;
            window.removeTourException = removeTourException;
        });
    </script>

</x-admin-layout>
