<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class PermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create Permissions
        $permissions = [
            'dashboard',
            'user-list',
            'user-add',
            'user-edit',
            'user-delete',
            'roles',
            'group-enable-disable',
            'group-list',
            'group-add',
            'group-edit',
            'group-delete',
            'response-template-enable-disable',
            'response-template-list',
            'response-template-add',
            'response-template-edit',
            'response-template-delete',
            'channel-enable-disable',
            'channel-list',
            'channel-add',
            'channel-edit',
            'channel-delete',
            'channel-commission',
            'tour-import',
            'tour-published-unpublished',
            'tour-list',
            'tour-add',
            'tour-edit',
            'tour-delete'
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }

        // Create Admin Role if not exists
        $admin = Role::firstOrCreate(['name' => 'admin']);

        // Assign all permissions to admin role
        $admin->syncPermissions(Permission::all());

        // Ensure a user exists before assigning a role
        $user = User::first(); // Get the first user in the database
        if (!$user) {
            $user = User::create([
                'name' => 'Admin User',
                'email' => 'admin@example.com',
                'password' => Hash::make('password'), // Change password as needed
            ]);
        }

        $user->assignRole('admin');
    }
}
