<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TourGuide extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'region_id', 'prefecture_id', 'city_id', 'station',
        'first_name', 'last_name', 'japanese_name', 'email', 'phone',
        'dob', 'gender', 'interpreter_license', 'license_number',
        'certifications', 'english_fluency', 'other_languages',
        'job_experience', 'years_of_experience', 'number_of_tours',
        'guide_areas', 'type_of_tours', 'type_of_tours_other', 'how_heard',
        'referred_person', 'how_heard_other', 'availability', 'status', 'position', 'work_area',
        'address', 'lat_long', 'other_license_number', 'private_vehicle', 'car_type', 'capacity', 'invoice_registration',
        'invoice_registration_number', 'bank_information', 'experience_area', 'notes', 'interviewed_by', 'interiewer_observations',
        'english_fluency_rating', 'communication_preferred', 'recording_of_interview', 'starting_rate', 'guide_fee',
        'important_notes', 'comment', 'line_user_id', 'line_group_id', 'contract', 'sign_date', 'interview_date'
    ];

    protected $casts = [
        'other_languages' => 'array',
        'guide_areas' => 'array',
        'type_of_tours' => 'array',
        'guide_fee' => 'array',
        'important_notes' => 'array',
    ];

    protected $appends = ['status_text'];
    protected $dates = ['deleted_at'];

    public function getStatusTextAttribute()
    {
        $statuses = ['Not Active', 'Active', 'Applied', 'Interviewed', 'Declined', 'Rejected'];
        return $statuses[$this->status] ?? 'Unknown';
    }

    public function region()
    {
        return $this->belongsTo(Region::class, 'region_id');
    }

    public function prefecture()
    {
        return $this->belongsTo(Prefecture::class, 'prefecture_id');
    }

    public function city()
    {
        return $this->belongsTo(City::class, 'city_id');
    }

    public function otherLanguages()
    {
        return $this->belongsToMany(OtherLanguage::class, 'other_language_tour_guide');
    }

}
