<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TourExceptionCommission extends Model
{
    use SoftDeletes;

    protected $fillable = ['channel_commission_id', 'tour_id', 'title', 'commission'];
    protected $dates = ['deleted_at'];

    public function channelCommission()
    {
        return $this->belongsTo(ChannelCommission::class);
    }

    public function tour()
    {
        return $this->belongsTo(Tour::class);
    }
}
