<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ChannelCommission extends Model
{
    use SoftDeletes;

    protected $fillable = ['channel_id', 'title', 'commission'];
    protected $dates = ['deleted_at'];

    public function channel()
    {
        return $this->belongsTo(Channel::class);
    }

    public function tourExceptions()
    {
        return $this->hasMany(TourExceptionCommission::class, 'channel_commission_id');
    }
}
