<?php

namespace App\Jobs;

use App\Mail\ContractMail;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Mail;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Storage;

class SendScheduledMail implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $email;
    public $subject;
    public $body;
    public $title;
    public $pdfPath;

    public function __construct($email, $subject, $body, $title, $pdfPath)
    {
        $this->email = $email;
        $this->subject = $subject;
        $this->body = $body;
        $this->title = $title;
        $this->pdfPath = $pdfPath;
    }

    public function handle()
    {
        Mail::to($this->email)->send(new ContractMail($this->subject, $this->body, $this->title, $this->pdfPath));
    }
}
