<?php

use App\Models\Region;
use App\Models\Prefecture;
use App\Models\City;

if (!function_exists('isJson')) {
    function isJson($string) {
        json_decode($string);
        return (json_last_error() == JSON_ERROR_NONE);
    }
}

if (!function_exists('getRegionName')) {
    function getRegionName($id) {
        return Region::find($id)?->eng_name ?? 'Unknown Region';
    }
}

if (!function_exists('getPrefectureName')) {
    function getPrefectureName($id) {
        return Prefecture::find($id)?->eng_name ?? 'Unknown Prefecture';
    }
}

if (!function_exists('getCityName')) {
    function getCityName($id) {
        return City::find($id)?->eng_name ?? 'Unknown City';
    }
}
