<header class="flex items-center justify-between px-6 py-3 bg-white shadow-md relative">
    <div>
        <h1 class="text-lg font-semibold text-black"><?php echo e(__('common.hello')); ?>, <span><?php echo e(auth()->user()->name); ?>!</span></h1>
        <p class="text-sm text-gray-500 mt-1"><?php echo e(__('common.welcome_back_and_here_is_your_agenda')); ?></p>
    </div>

    <div class="flex items-center mx-4 relative">
        <!-- Search Bar -->
        <div class="flex-1">
            <div class="relative w-full">
                <input type="text" class="w-full pl-4 pr-8 py-3 text-sm border focus:ring-gray-900 focus:border-gray-900 bg-white" style="border-radius:16px;" placeholder="<?php echo e(__('common.search')); ?>">
                
            </div>
        </div>

        <!-- Language Selector -->
        <div class="relative mx-4" x-data="{ openLang: false }">
            <button @click="openLang = !openLang" class="flex items-center space-x-1 px-3 py-2 bg-gray-100 hover:bg-gray-200 text-sm text-gray-700 rounded-md border border-gray-200 focus:outline-none">
                <span class="inline-block"><?php echo e(__('common.language')); ?></span>
                <svg class="w-4 h-4 mt-[2px] text-gray-500" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"/>
                </svg>
            </button>

            <div x-show="openLang" @click.away="openLang = false" class="absolute right-0 z-20 mt-2 w-32 bg-white rounded-md shadow-lg">
                <a href="<?php echo e(route('lang.switch', ['locale' => 'en'])); ?>" class="block px-2 py-2 text-sm text-gray-700 hover:bg-gray-600 hover:text-white"><?php echo e(__('common.english')); ?></a>
                <a href="<?php echo e(route('lang.switch', ['locale' => 'ja'])); ?>" class="block px-2 py-2 text-sm text-gray-700 hover:bg-gray-600 hover:text-white"><?php echo e(__('common.japanese')); ?></a>
            </div>
        </div>

        <!-- Notification Bell -->
        <div class="flex mx-4">
            <div x-data="{ notificationOpen: false }" class="relative">
                <button @click="notificationOpen = !notificationOpen" class="relative text-gray-600 focus:outline-none p-2 bg-gray-100 rounded-full hover:bg-gray-200 border-2 border-gray-100">
                    <svg class="w-6 h-6" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M15 17H20L18.5951 15.5951C18.2141 15.2141 18 14.6973 18 14.1585V11C18 8.38757 16.3304 6.16509 14 5.34142V5C14 3.89543 13.1046 3 12 3C10.8954 3 10 3.89543 10 5V5.34142C7.66962 6.16509 6 8.38757 6 11V14.1585C6 14.6973 5.78595 15.2141 5.40493 15.5951L4 17H9M15 17V18C15 19.6569 13.6569 21 12 21C10.3431 21 9 19.6569 9 18V17M15 17H9" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </button>

                <div x-cloak x-show="notificationOpen" @click="notificationOpen = false" class="fixed inset-0 z-10 w-full h-full"></div>

                <div x-cloak x-show="notificationOpen" class="absolute right-0 z-10 mt-2 overflow-hidden bg-white rounded-lg shadow-xl w-80" style="width:20rem;">
                    <a href="#" class="flex items-center px-4 py-3 -mx-2 text-gray-600 hover:text-white hover:bg-indigo-600">
                        <img class="object-cover w-8 h-8 mx-1 rounded-full" src="https://images.unsplash.com/photo-1494790108377-be9c29b29330?ixlib=rb-1.2.1&ixid=eyJhcHBfaWQiOjEyMDd9&auto=format&fit=crop&w=334&q=80" alt="avatar">
                        <p class="mx-2 text-sm">
                            <span class="font-bold" href="#">Sara Salah</span> replied on the <span class="font-bold text-indigo-400" href="#">Upload Image</span> artical . 2m
                        </p>
                    </a>
                    <a href="#" class="flex items-center px-4 py-3 -mx-2 text-gray-600 hover:text-white hover:bg-indigo-600">
                        <img class="object-cover w-8 h-8 mx-1 rounded-full" src="https://images.unsplash.com/photo-1531427186611-ecfd6d936c79?ixlib=rb-1.2.1&ixid=eyJhcHBfaWQiOjEyMDd9&auto=format&fit=crop&w=634&q=80" alt="avatar">
                        <p class="mx-2 text-sm">
                            <span class="font-bold" href="#">Slick Net</span> start following you . 45m
                        </p>
                    </a>
                    <a href="#" class="flex items-center px-4 py-3 -mx-2 text-gray-600 hover:text-white hover:bg-indigo-600">
                        <img class="object-cover w-8 h-8 mx-1 rounded-full" src="https://images.unsplash.com/photo-1450297350677-623de575f31c?ixlib=rb-1.2.1&ixid=eyJhcHBfaWQiOjEyMDd9&auto=format&fit=crop&w=334&q=80" alt="avatar">
                        <p class="mx-2 text-sm">
                            <span class="font-bold" href="#">Jane Doe</span> Like Your reply on <span class="font-bold text-indigo-400" href="#">Test with TDD</span> artical . 1h
                        </p>
                    </a>
                    <a href="#" class="flex items-center px-4 py-3 -mx-2 text-gray-600 hover:text-white hover:bg-indigo-600">
                        <img class="object-cover w-8 h-8 mx-1 rounded-full" src="https://images.unsplash.com/photo-1580489944761-15a19d654956?ixlib=rb-1.2.1&ixid=eyJhcHBfaWQiOjEyMDd9&auto=format&fit=crop&w=398&q=80" alt="avatar">
                        <p class="mx-2 text-sm">
                            <span class="font-bold" href="#">Abigail Bennett</span> start following you . 3h
                        </p>
                    </a>
                </div>
            </div>
        </div>

        <!-- Profile Dropdown -->
        <div class="relative flex" x-data="{ open: false }">
            <button @click="open = !open" class="flex items-center space-x-2 focus:outline-none">
                <img class="ml-122 w-10 h-10 object-cover mx-1 rounded-full" src="https://images.unsplash.com/photo-1494790108377-be9c29b29330?ixlib=rb-1.2.1&ixid=eyJhcHBfaWQiOjEyMDd9&auto=format&fit=crop&w=334&q=80" alt="avatar">
                <span class="mr-2 text-gray-700"><?php echo e(auth()->user()->name); ?></span>
                <svg class="w-5 h-5 mt-1 text-sm text-gray-500" viewBox="0 0 20 20" fill="currentColor">
                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"/>
                </svg>
            </button>

            <!-- Dropdown Menu -->
            <div x-show="open" @click.away="open = false" class="absolute right-0 mt-2 w-48 bg-white rounded-md shadow-lg">
                <a href="#" class="block px-4 py-2 text-gray-700 hover:bg-indigo-600 hover:text-white"><?php echo e(__('common.profile')); ?></a>
                <a href="#" class="block px-4 py-2 text-gray-700 hover:bg-indigo-600 hover:text-white"><?php echo e(__('common.settings')); ?></a>
            </div>
        </div>
    </div>
</header>

<!-- Alpine.js Include -->
<script src="https://cdn.jsdelivr.net/npm/alpinejs@2.x.x/dist/alpine.min.js" defer></script>
<?php /**PATH C:\xampp8.2\htdocs\Portal\resources\views/layouts/admin/header.blade.php ENDPATH**/ ?>