<div x-cloak :class="sidebarOpen ? 'block' : 'hidden'" @click="sidebarOpen = false" class="fixed inset-0 z-20 transition-opacity bg-black opacity-50 lg:hidden"></div>

<div x-cloak :class="sidebarOpen ? 'translate-x-0 ease-out' : '-translate-x-full ease-in'" class="fixed inset-y-0 left-0 z-30 w-64 overflow-y-auto transition duration-300 transform bg-white lg:translate-x-0 lg:static lg:inset-0">
    <div class="flex items-center justify-between mt-6">
        <div class="flex items-center">
            <img class="object-cover w-12 h-12 mx-4 rounded-full" src="<?php echo e(asset('img/logo.png')); ?>" alt="avatar">
        </div>

        <!-- Sidebar Toggle Button -->
        <button @click="sidebarOpen = !sidebarOpen" class="mx-3 px-1 py-0 rounded-md">
            <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M10.9426 0.0570147H11.0574C13.3658 0.0570018 15.1748 0.0569916 16.5863 0.246761C18.031 0.441001 19.1711 0.846341 20.0659 1.74115C20.9607 2.63596 21.366 3.77598 21.5603 5.22072C21.75 6.63221 21.75 8.44125 21.75 10.7496V10.8644C21.75 13.1728 21.75 14.9818 21.5603 16.3933C21.366 17.838 20.9607 18.9781 20.0659 19.8729C19.1711 20.7677 18.031 21.173 16.5863 21.3673C15.1748 21.557 13.3658 21.557 11.0574 21.557H10.9426C8.63423 21.557 6.82519 21.557 5.41371 21.3673C3.96897 21.173 2.82895 20.7677 1.93414 19.8729C1.03933 18.9781 0.633986 17.838 0.439747 16.3933C0.249977 14.9818 0.249987 13.1728 0.25 10.8644V10.7496C0.249987 8.44124 0.249977 6.63221 0.439747 5.22072C0.633986 3.77598 1.03933 2.63596 1.93414 1.74115C2.82895 0.846341 3.96897 0.441001 5.41371 0.246761C6.82519 0.0569916 8.63423 0.0570018 10.9426 0.0570147ZM5.61358 1.73339C4.33517 1.90526 3.56445 2.23215 2.9948 2.80181C2.42514 3.37147 2.09825 4.14219 1.92637 5.42059C1.75159 6.72057 1.75 8.42879 1.75 10.807C1.75 13.1852 1.75159 14.8935 1.92637 16.1934C2.09825 17.4718 2.42514 18.2426 2.9948 18.8122C3.56445 19.3819 4.33517 19.7088 5.61358 19.8806C6.91356 20.0554 8.62177 20.057 11 20.057C13.3782 20.057 15.0864 20.0554 16.3864 19.8806C17.6648 19.7088 18.4355 19.3819 19.0052 18.8122C19.5749 18.2426 19.9018 17.4718 20.0736 16.1934C20.2484 14.8935 20.25 13.1852 20.25 10.807C20.25 8.42879 20.2484 6.72057 20.0736 5.42059C19.9018 4.14219 19.5749 3.37147 19.0052 2.80181C18.4355 2.23215 17.6648 1.90526 16.3864 1.73339C15.0864 1.55861 13.3782 1.55701 11 1.55701C8.62177 1.55701 6.91356 1.55861 5.61358 1.73339ZM11.0303 7.27668C11.3232 7.56958 11.3232 8.04445 11.0303 8.33735L8.56066 10.807L11.0303 13.2767C11.3232 13.5696 11.3232 14.0445 11.0303 14.3373C10.7374 14.6302 10.2626 14.6302 9.96967 14.3373L6.96967 11.3373C6.67678 11.0445 6.67678 10.5696 6.96967 10.2767L9.96967 7.27668C10.2626 6.98379 10.7374 6.98379 11.0303 7.27668ZM15.0303 7.27668C15.3232 7.56958 15.3232 8.04445 15.0303 8.33735L12.5607 10.807L15.0303 13.2767C15.3232 13.5696 15.3232 14.0445 15.0303 14.3373C14.7374 14.6302 14.2626 14.6302 13.9697 14.3373L10.9697 11.3373C10.6768 11.0445 10.6768 10.5696 10.9697 10.2767L13.9697 7.27668C14.2626 6.98379 14.7374 6.98379 15.0303 7.27668Z" fill="#8A8C92"/>
            </svg>
        </button>
    </div>

    <nav class="h-screen flex flex-col justify-between">
        <div class="px-2 py-1">
        <a class="flex items-center px-6 py-2 mt-4 text-black-Primary rounded"  style="<?php echo e(Route::currentRouteNamed('admin.dashboard') ? 'background-color: #2E8B57;' : ''); ?>" href="<?php echo e(route('admin.dashboard')); ?>">
            <svg width="22" height="23" viewBox="0 0 22 23" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M8 16.864C7.58579 16.864 7.25 17.1998 7.25 17.614C7.25 18.0282 7.58579 18.364 8 18.364H14C14.4142 18.364 14.75 18.0282 14.75 17.614C14.75 17.1998 14.4142 16.864 14 16.864H8Z" fill="#111111"/>
                <path fill-rule="evenodd" clip-rule="evenodd" d="M11 0.864029C10.2919 0.864029 9.64853 1.06685 8.95055 1.40627C8.27585 1.73437 7.49642 2.21812 6.52286 2.82235L4.45628 4.10493C3.53509 4.67664 2.79744 5.13443 2.2289 5.56984C1.64015 6.02072 1.18795 6.47992 0.86131 7.07666C0.535355 7.67215 0.388567 8.30577 0.31819 9.05473C0.249986 9.78057 0.249992 10.6681 0.25 11.7813V13.3939C0.249986 15.2978 0.249975 16.8006 0.402703 17.9756C0.559372 19.181 0.888563 20.1541 1.63236 20.9235C2.37958 21.6964 3.33046 22.0417 4.50761 22.2054C5.64849 22.3641 7.10556 22.364 8.94185 22.364H13.0581C14.8944 22.364 16.3515 22.3641 17.4924 22.2054C18.6695 22.0417 19.6204 21.6964 20.3676 20.9235C21.1114 20.1541 21.4406 19.181 21.5973 17.9756C21.75 16.8006 21.75 15.2978 21.75 13.3939V11.7812C21.75 10.6682 21.75 9.78055 21.6818 9.05473C21.6114 8.30577 21.4646 7.67215 21.1387 7.07666C20.8121 6.47992 20.3599 6.02072 19.7711 5.56984C19.2026 5.13443 18.4649 4.67665 17.5437 4.10494L15.4771 2.82234C14.5036 2.21812 13.7241 1.73437 13.0494 1.40627C12.3515 1.06685 11.7081 0.864029 11 0.864029ZM7.27953 4.11815C8.29529 3.48774 9.0095 3.04556 9.60654 2.75522C10.1882 2.47235 10.6002 2.36403 11 2.36403C11.3998 2.36403 11.8118 2.47235 12.3935 2.75522C12.9905 3.04556 13.7047 3.48774 14.7205 4.11815L16.7205 5.3594C17.6813 5.95572 18.3559 6.37538 18.8591 6.76073C19.3487 7.13567 19.6303 7.44509 19.8229 7.79688C20.0162 8.14992 20.129 8.56268 20.1884 9.19506C20.2492 9.84262 20.25 10.6598 20.25 11.8179V13.339C20.25 15.3099 20.2485 16.7152 20.1098 17.7823C19.9736 18.8304 19.717 19.4384 19.2892 19.8809C18.8649 20.3198 18.2871 20.5804 17.2858 20.7197C16.2602 20.8623 14.9075 20.864 13 20.864H9C7.09247 20.864 5.73983 20.8623 4.71422 20.7197C3.71286 20.5804 3.13514 20.3198 2.71079 19.8809C2.28301 19.4384 2.02642 18.8304 1.89019 17.7823C1.75149 16.7152 1.75 15.3099 1.75 13.339V11.8179C1.75 10.6598 1.75076 9.84262 1.81161 9.19506C1.87103 8.56268 1.98385 8.14992 2.17709 7.79688C2.36965 7.44509 2.65133 7.13567 3.14092 6.76073C3.6441 6.37538 4.31869 5.95572 5.27953 5.3594L7.27953 4.11815Z" fill="#111111"/>
                </svg>
            <span class="mx-3 text-sm"><?php echo e(__('common.dashboard')); ?></span>
        </a>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['user-list', 'roles', 'channel-list'])): ?>
        <div class="relative group">
            <button data-dropdown-button class="flex items-center px-6 py-2 mt-4 text-black-Primary rounded"  style="<?php echo e(Route::currentRouteNamed('admin.users.index') || Route::currentRouteNamed('admin.roles.index') || Route::currentRouteNamed('admin.permissions.index') || Route::currentRouteNamed('admin.channels.index') ? 'background-color: #2E8B57;' : ''); ?>">
                <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z">
                    </path>
                </svg>
                <span class="mx-3 text-sm"><?php echo e(__('common.configuration')); ?></span>
                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 ml-2 -mr-1" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                    <path fill-rule="evenodd" d="M6.293 9.293a1 1 0 011.414 0L10 11.586l2.293-2.293a1 1 0 111.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z" clip-rule="evenodd" />
                </svg>
            </button>
            <div data-dropdown-menu class="w-full dropdown_branding <?php echo e(Route::currentRouteNamed('admin.users.index') ||
                    Route::currentRouteNamed('admin.roles.index') ||
                    Route::currentRouteNamed('admin.permissions.index') ||
                    Route::currentRouteNamed('admin.channels.index')
                    ? '' : 'hidden'); ?>" data-show="<?php echo e(Route::currentRouteNamed('admin.users.index') ||
                    Route::currentRouteNamed('admin.roles.index') ||
                    Route::currentRouteNamed('admin.permissions.index') ||
                    Route::currentRouteNamed('admin.channels.index')
                    ? 'true' : 'false'); ?>">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user-list')): ?>
                <a class="flex items-center px-6 py-2 mt-4 ml-5 text-black-Primary rounded" style="<?php echo e(Route::currentRouteNamed('admin.users.index') ? 'background-color: #2E8B57;' : ''); ?>" href="<?php echo e(route('admin.users.index')); ?>">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 14v6m-3-3h6M6 10h2a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v2a2 2 0 002 2zm10 0h2a2 2 0 002-2V6a2 2 0 00-2-2h-2a2 2 0 00-2 2v2a2 2 0 002 2zM6 20h2a2 2 0 002-2v-2a2 2 0 00-2-2H6a2 2 0 00-2 2v2a2 2 0 002 2z" />
                    </svg>

                    <span class="mx-3 text-sm"><?php echo e(__('common.user')); ?></span>
                </a>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('roles')): ?>
                <a class="flex items-center px-6 py-2 mt-4 ml-5 text-black-Primary rounded" style="<?php echo e(Route::currentRouteNamed('admin.roles.index') ? 'background-color: #2E8B57;' : ''); ?>" href="<?php echo e(route('admin.roles.index')); ?>">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                    </svg>

                    <span class="mx-3 text-sm"><?php echo e(__('common.role')); ?></span>
                </a>
                <?php endif; ?>
                <?php if (\Illuminate\Support\Facades\Blade::check('role', 'admin')): ?>
                <a class="flex items-center px-6 py-2 mt-4 ml-5 text-black-Primary rounded" style="<?php echo e(Route::currentRouteNamed('admin.permissions.index') ? 'background-color: #2E8B57;' : ''); ?>" href="<?php echo e(route('admin.permissions.index')); ?>">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                    </svg>

                    <span class="mx-3 text-sm"><?php echo e(__('common.permission')); ?></span>
                </a>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('channel-list')): ?>
                <a class="flex items-center px-6 py-2 mt-4 ml-5 text-black-Primary rounded" style="<?php echo e(Route::currentRouteNamed('admin.channels.index') ? 'background-color: #2E8B57;' : ''); ?>" href="<?php echo e(route('admin.channels.index')); ?>">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                    </svg>

                    <span class="mx-3 text-sm"><?php echo e(__('common.channels')); ?></span>
                </a>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['group-list', 'response-template-list', 'channel-commission', 'tour-list'])): ?>
        <div class="relative group">
            <button data-dropdown-button class="flex items-center px-6 py-2 mt-4 text-black-Primary rounded" style="<?php echo e(Route::currentRouteNamed('admin.groups.index') || Route::currentRouteNamed('admin.response_templates.index') || Route::currentRouteNamed('admin.channel_commissions.index') || Route::currentRouteNamed('admin.tour_settings.index') ? 'background-color: #2E8B57;' : ''); ?>">
                <svg width="22" height="23" viewBox="0 0 22 23" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M10.948 0.86403H11.052C11.9505 0.864001 12.6997 0.863976 13.2945 0.943942C13.9223 1.02835 14.4891 1.21402 14.9445 1.66949C15.4 2.12496 15.5857 2.69176 15.6701 3.31955C15.7292 3.75915 15.7446 4.28312 15.7486 4.88936C16.3971 4.91017 16.9752 4.94809 17.489 5.01717C18.6614 5.17479 19.6104 5.50691 20.3588 6.25527C21.1071 7.00364 21.4392 7.95259 21.5969 9.12501C21.75 10.2642 21.75 11.7199 21.75 13.5576V13.6704C21.75 15.5082 21.75 16.9638 21.5969 18.1031C21.4392 19.2755 21.1071 20.2244 20.3588 20.9728C19.6104 21.7212 18.6614 22.0533 17.489 22.2109C16.3498 22.3641 14.8942 22.364 13.0564 22.364H8.94359C7.10583 22.364 5.65019 22.3641 4.51098 22.2109C3.33856 22.0533 2.38961 21.7212 1.64124 20.9728C0.89288 20.2244 0.560763 19.2755 0.403135 18.1031C0.249972 16.9638 0.249984 15.5082 0.25 13.6704V13.5576C0.249984 11.7199 0.249972 10.2642 0.403135 9.12501C0.560763 7.95259 0.89288 7.00364 1.64124 6.25527C2.38961 5.50691 3.33856 5.17479 4.51098 5.01717C5.02475 4.94809 5.60288 4.91017 6.2514 4.88936C6.2554 4.28312 6.27081 3.75915 6.32991 3.31955C6.41432 2.69176 6.59999 2.12496 7.05546 1.66949C7.51093 1.21402 8.07773 1.02835 8.70552 0.943942C9.3003 0.863976 10.0495 0.864001 10.948 0.86403ZM7.7518 4.86581C8.12993 4.86402 8.52694 4.86403 8.94358 4.86403H13.0564C13.4731 4.86403 13.8701 4.86402 14.2482 4.86581C14.244 4.29549 14.23 3.86528 14.1835 3.51942C14.1214 3.05796 14.0142 2.86046 13.8839 2.73015C13.7536 2.59983 13.5561 2.49261 13.0946 2.43057C12.6116 2.36562 11.964 2.36403 11 2.36403C10.036 2.36403 9.38843 2.36562 8.90539 2.43057C8.44393 2.49261 8.24643 2.59983 8.11612 2.73015C7.9858 2.86046 7.87858 3.05796 7.81654 3.51942C7.77004 3.86528 7.75601 4.29549 7.7518 4.86581ZM4.25 6.57993C3.51924 6.72662 3.05586 6.96198 2.7019 7.31593C2.27869 7.73914 2.02502 8.31879 1.88976 9.32488C1.75159 10.3525 1.75 11.7072 1.75 13.614C1.75 15.5209 1.75159 16.8755 1.88976 17.9032C2.02502 18.9093 2.27869 19.4889 2.7019 19.9121C3.05586 20.2661 3.51924 20.5014 4.25 20.6481V18.3225C4.04984 18.2835 3.81689 18.1987 3.61612 17.9979C3.38032 17.7621 3.30448 17.4819 3.27499 17.2626C3.24982 17.0754 3.24991 16.8536 3.24999 16.6485C3.25 16.6369 3.25 16.6255 3.25 16.614V15.614C3.25 15.6026 3.25 15.5911 3.24999 15.5796C3.24991 15.3745 3.24982 15.1527 3.27499 14.9655C3.30448 14.7461 3.38032 14.4659 3.61612 14.2301C3.81689 14.0294 4.04984 13.9446 4.25 13.9056V6.57993ZM5.75 6.41159V13.864H9C9.01142 13.864 9.02291 13.864 9.03444 13.864C9.23956 13.8639 9.46135 13.8639 9.64857 13.889C9.8679 13.9185 10.1481 13.9943 10.3839 14.2301C10.6197 14.4659 10.6955 14.7461 10.725 14.9655C10.7502 15.1527 10.7501 15.3745 10.75 15.5796C10.75 15.5911 10.75 15.6026 10.75 15.614V16.614C10.75 16.6255 10.75 16.6369 10.75 16.6485C10.7501 16.8536 10.7502 17.0754 10.725 17.2626C10.6955 17.4819 10.6197 17.7621 10.3839 17.9979C10.1481 18.2337 9.8679 18.3096 9.64857 18.339C9.46135 18.3642 9.23956 18.3641 9.03444 18.364C9.02291 18.364 9.01142 18.364 9 18.364H5.75V20.8165C6.61719 20.8633 7.67537 20.864 9 20.864H13C14.3246 20.864 15.3828 20.8633 16.25 20.8165V6.41159C15.3828 6.3648 14.3246 6.36403 13 6.36403H9C7.67537 6.36403 6.61719 6.3648 5.75 6.41159ZM17.75 6.57993V20.6481C18.4808 20.5014 18.9441 20.2661 19.2981 19.9121C19.7213 19.4889 19.975 18.9093 20.1102 17.9032C20.2484 16.8755 20.25 15.5209 20.25 13.614C20.25 11.7072 20.2484 10.3525 20.1102 9.32488C19.975 8.31879 19.7213 7.73914 19.2981 7.31593C18.9441 6.96198 18.4808 6.72662 17.75 6.57993ZM4.75115 15.3652C4.75004 15.4346 4.75 15.515 4.75 15.614V16.614C4.75 16.7131 4.75003 16.7934 4.75115 16.8629C4.82061 16.864 4.90092 16.864 5 16.864H9C9.09908 16.864 9.17939 16.864 9.24885 16.8629C9.24997 16.7934 9.25 16.7131 9.25 16.614V15.614C9.25 15.515 9.24997 15.4346 9.24885 15.3652C9.17939 15.3641 9.09908 15.364 9 15.364H5C4.90092 15.364 4.82061 15.3641 4.75115 15.3652Z" fill="#111111"/>
                </svg>
                <span class="mx-3 text-sm"><?php echo e(__('common.tour/experience')); ?></span>
                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 ml-2 -mr-1" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                    <path fill-rule="evenodd" d="M6.293 9.293a1 1 0 011.414 0L10 11.586l2.293-2.293a1 1 0 111.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z" clip-rule="evenodd" />
                </svg>
            </button>
            <div data-dropdown-menu class="w-full dropdown_branding <?php echo e(Route::currentRouteNamed('admin.groups.index') ||
                    Route::currentRouteNamed('admin.response_templates.index') ||
                    Route::currentRouteNamed('admin.channel_commissions.index') ||
                    Route::currentRouteNamed('admin.tour_settings.index')
                    ? '' : 'hidden'); ?>" data-show="<?php echo e(Route::currentRouteNamed('admin.groups.index') ||
                    Route::currentRouteNamed('admin.response_templates.index') ||
                    Route::currentRouteNamed('admin.channel_commissions.index') ||
                    Route::currentRouteNamed('admin.tour_settings.index')
                    ? 'true' : 'false'); ?>">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('group-list')): ?>
                <a class="flex items-center px-6 py-2 mt-4 ml-5 text-black-Primary rounded" style="<?php echo e(Route::currentRouteNamed('admin.groups.index') ? 'background-color: #2E8B57;' : ''); ?>" href="<?php echo e(route('admin.groups.index')); ?>">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 14v6m-3-3h6M6 10h2a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v2a2 2 0 002 2zm10 0h2a2 2 0 002-2V6a2 2 0 00-2-2h-2a2 2 0 00-2 2v2a2 2 0 002 2zM6 20h2a2 2 0 002-2v-2a2 2 0 00-2-2H6a2 2 0 00-2 2v2a2 2 0 002 2z" />
                    </svg>

                    <span class="mx-3 text-sm"><?php echo e(__('common.group')); ?></span>
                </a>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('response-template-list')): ?>
                <a class="flex items-center px-6 py-2 mt-4 ml-5 text-black-Primary rounded" style="<?php echo e(Route::currentRouteNamed('admin.response_templates.index') ? 'background-color: #2E8B57;' : ''); ?>" href="<?php echo e(route('admin.response_templates.index')); ?>">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                    </svg>

                    <span class="mx-2 text-sm"><?php echo e(__('common.response_template')); ?></span>
                </a>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('channel-commission')): ?>
                <a class="flex items-center px-6 py-2 mt-4 ml-5 text-black-Primary rounded" style="<?php echo e(Route::currentRouteNamed('admin.channel_commissions.index') ? 'background-color: #2E8B57;' : ''); ?>" href="<?php echo e(route('admin.channel_commissions.index')); ?>">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                    </svg>

                    <span class="mx-1 text-sm"><?php echo e(__('common.channel_commission')); ?></span>
                </a>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tour-list')): ?>
                <a class="flex items-center px-6 py-2 mt-4 ml-5 text-black-Primary rounded" style="<?php echo e(Route::currentRouteNamed('admin.tour_settings.index') ? 'background-color: #2E8B57;' : ''); ?>" href="<?php echo e(route('admin.tour_settings.index')); ?>">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                    </svg>

                    <span class="mx-1 text-sm"><?php echo e(__('common.tour_setting')); ?></span>
                </a>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>

        <a class="flex items-center px-2 py-2 mt-4 ml-5 text-black-Primary rounded" style="<?php echo e(Route::currentRouteNamed('admin.tour-guides.index') ? 'background-color: #2E8B57;' : ''); ?>" href="<?php echo e(route('admin.tour-guides.index')); ?>">
            <svg width="22" height="19" viewBox="0 0 22 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M8 3.86401C6.48122 3.86401 5.25 5.09523 5.25 6.61402C5.25 8.1328 6.48122 9.36401 8 9.36401C9.51878 9.36401 10.75 8.1328 10.75 6.61402C10.75 5.09523 9.51878 3.86401 8 3.86401ZM6.75 6.61402C6.75 5.92366 7.30964 5.36402 8 5.36402C8.69036 5.36402 9.25 5.92366 9.25 6.61402C9.25 7.30437 8.69036 7.86402 8 7.86402C7.30964 7.86402 6.75 7.30437 6.75 6.61402Z" fill="#111111"/>
                <path fill-rule="evenodd" clip-rule="evenodd" d="M8 9.86401C6.80424 9.86401 5.68461 10.1048 4.83616 10.529C4.03258 10.9308 3.25 11.6246 3.25 12.614L3.24987 12.6765C3.24834 13.1869 3.24575 14.0462 4.06023 14.6358C4.43818 14.9093 4.93689 15.0838 5.55469 15.195C6.1782 15.3072 6.97721 15.364 8 15.364C9.02279 15.364 9.8218 15.3072 10.4453 15.195C11.0631 15.0838 11.5618 14.9093 11.9398 14.6358C12.7542 14.0462 12.7517 13.1869 12.7501 12.6765L12.75 12.614C12.75 11.6246 11.9674 10.9308 11.1638 10.529C10.3154 10.1048 9.19576 9.86401 8 9.86401ZM4.75 12.614C4.75 12.4989 4.86285 12.1927 5.50698 11.8706C6.10625 11.571 6.98662 11.364 8 11.364C9.01338 11.364 9.89375 11.571 10.493 11.8706C11.1371 12.1927 11.25 12.4989 11.25 12.614C11.25 13.2185 11.2115 13.3112 11.0602 13.4207C10.9382 13.509 10.6869 13.6274 10.1797 13.7187C9.6782 13.8089 8.97721 13.864 8 13.864C7.02279 13.864 6.3218 13.8089 5.82031 13.7187C5.3131 13.6274 5.06182 13.509 4.93977 13.4207C4.78849 13.3112 4.75 13.2185 4.75 12.614Z" fill="#111111"/>
                <path d="M18 10.364C18.4142 10.364 18.75 10.0282 18.75 9.61401C18.75 9.1998 18.4142 8.86401 18 8.86401H14C13.5858 8.86401 13.25 9.1998 13.25 9.61401C13.25 10.0282 13.5858 10.364 14 10.364H18Z" fill="#111111"/>
                <path d="M18.75 6.61402C18.75 7.02823 18.4142 7.36402 18 7.36402H13C12.5858 7.36402 12.25 7.02823 12.25 6.61402C12.25 6.1998 12.5858 5.86402 13 5.86402H18C18.4142 5.86402 18.75 6.1998 18.75 6.61402Z" fill="#111111"/>
                <path d="M18 13.364C18.4142 13.364 18.75 13.0282 18.75 12.614C18.75 12.1998 18.4142 11.864 18 11.864H15C14.5858 11.864 14.25 12.1998 14.25 12.614C14.25 13.0282 14.5858 13.364 15 13.364H18Z" fill="#111111"/>
                <path fill-rule="evenodd" clip-rule="evenodd" d="M8.94358 0.864014H13.0564C14.8942 0.863999 16.3498 0.863986 17.489 1.01715C18.6614 1.17478 19.6104 1.50689 20.3588 2.25526C21.1071 3.00362 21.4392 3.95257 21.5969 5.12499C21.75 6.2642 21.75 7.71982 21.75 9.55756V9.67043C21.75 11.5082 21.75 12.9638 21.5969 14.103C21.4392 15.2755 21.1071 16.2244 20.3588 16.9728C19.6104 17.7211 18.6614 18.0533 17.489 18.2109C16.3498 18.364 14.8942 18.364 13.0565 18.364H8.94359C7.10585 18.364 5.65018 18.364 4.51098 18.2109C3.33855 18.0533 2.38961 17.7211 1.64124 16.9728C0.892879 16.2244 0.560762 15.2755 0.403134 14.103C0.249971 12.9638 0.249983 11.5082 0.249998 9.67045V9.5576C0.249983 7.71984 0.249971 6.2642 0.403134 5.12499C0.560762 3.95257 0.892879 3.00362 1.64124 2.25526C2.38961 1.50689 3.33855 1.17478 4.51098 1.01715C5.65019 0.863986 7.10583 0.863999 8.94358 0.864014ZM4.71085 2.50377C3.70476 2.63904 3.12511 2.89271 2.7019 3.31592C2.27869 3.73913 2.02502 4.31877 1.88976 5.32486C1.75159 6.35253 1.75 7.70719 1.75 9.61401C1.75 11.5208 1.75159 12.8755 1.88976 13.9032C2.02502 14.9093 2.27869 15.4889 2.7019 15.9121C3.12511 16.3353 3.70476 16.589 4.71085 16.7243C5.73851 16.8624 7.09318 16.864 9 16.864H13C14.9068 16.864 16.2615 16.8624 17.2892 16.7243C18.2952 16.589 18.8749 16.3353 19.2981 15.9121C19.7213 15.4889 19.975 14.9093 20.1102 13.9032C20.2484 12.8755 20.25 11.5208 20.25 9.61401C20.25 7.70719 20.2484 6.35253 20.1102 5.32486C19.975 4.31877 19.7213 3.73913 19.2981 3.31592C18.8749 2.89271 18.2952 2.63904 17.2891 2.50377C16.2615 2.36561 14.9068 2.36401 13 2.36401H9C7.09318 2.36401 5.73851 2.36561 4.71085 2.50377Z" fill="#111111"/>
            </svg>
            <span class="mx-3 text-sm"><?php echo e(__('common.tour_guides')); ?></span>
        </a>
        </div>
        <div class="px-6 py-4">
            <form method="POST" action="<?php echo e(route('logout')); ?>">
                <?php echo csrf_field(); ?>
                <button type="submit" class="flex items-center w-full py-2 text-black-Primary rounded hover:bg-gray-100">
                    <svg width="20" height="22" viewBox="0 0 20 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M3.46967 11.5303C3.17678 11.2374 3.17678 10.7626 3.46967 10.4697L5.46967 8.46967C5.76256 8.17678 6.23744 8.17678 6.53033 8.46967C6.82322 8.76256 6.82322 9.23744 6.53033 9.53033L5.81066 10.25L13 10.25C13.4142 10.25 13.75 10.5858 13.75 11C13.75 11.4142 13.4142 11.75 13 11.75L5.81066 11.75L6.53033 12.4697C6.82322 12.7626 6.82322 13.2374 6.53033 13.5303C6.23744 13.8232 5.76256 13.8232 5.46967 13.5303L3.46967 11.5303Z" fill="#1C274C"/>
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M11.9453 0.250001H13.0551C14.4227 0.24998 15.525 0.249964 16.392 0.366524C17.2921 0.487541 18.0499 0.746434 18.6519 1.34835C19.2538 1.95027 19.5127 2.70814 19.6337 3.60825C19.7503 4.47522 19.7502 5.57754 19.7502 6.94513V15.0549C19.7502 16.4225 19.7503 17.5248 19.6337 18.3918C19.5127 19.2919 19.2538 20.0497 18.6519 20.6517C18.0499 21.2536 17.2921 21.5125 16.392 21.6335C15.525 21.75 14.4227 21.75 13.0551 21.75H11.9453C10.5778 21.75 9.47543 21.75 8.60846 21.6335C7.70836 21.5125 6.95048 21.2536 6.34857 20.6517C5.94963 20.2527 5.70068 19.7844 5.54304 19.2498C4.59168 19.2486 3.79906 19.2381 3.15689 19.1518C2.39293 19.0491 1.7306 18.8268 1.2019 18.2981C0.67321 17.7694 0.450928 17.1071 0.348218 16.3431C0.249956 15.6123 0.249976 14.6865 0.249999 13.5537V8.44631C0.249976 7.31349 0.249956 6.38774 0.348218 5.65689C0.450928 4.89294 0.67321 4.2306 1.2019 3.7019C1.7306 3.17321 2.39293 2.95093 3.15689 2.84822C3.79906 2.76188 4.59168 2.75142 5.54304 2.75017C5.70068 2.21562 5.94963 1.74729 6.34857 1.34835C6.95048 0.746434 7.70836 0.487541 8.60847 0.366524C9.47543 0.249964 10.5778 0.24998 11.9453 0.250001ZM5.25197 16.0042C5.25555 16.6487 5.26619 17.2293 5.30284 17.7491C4.46836 17.7459 3.848 17.7312 3.35676 17.6652C2.75914 17.5848 2.4661 17.441 2.26256 17.2374C2.05902 17.0339 1.91519 16.7409 1.83484 16.1432C1.75159 15.5241 1.75 14.6997 1.75 13.5V8.5C1.75 7.30029 1.75159 6.47595 1.83484 5.85676C1.91519 5.25914 2.05902 4.9661 2.26256 4.76256C2.4661 4.55902 2.75914 4.41519 3.35676 4.33484C3.848 4.2688 4.46836 4.25415 5.30284 4.25091C5.26619 4.77073 5.25555 5.35129 5.25197 5.99583C5.24966 6.41003 5.58357 6.74768 5.99778 6.74999C6.41199 6.7523 6.74964 6.41838 6.75194 6.00418C6.75803 4.91068 6.78643 4.1356 6.89448 3.54735C6.99859 2.98054 7.16577 2.65246 7.40923 2.40901C7.68599 2.13225 8.07456 1.9518 8.80834 1.85315C9.56369 1.75159 10.5648 1.75 12.0002 1.75H13.0002C14.4356 1.75 15.4367 1.75159 16.1921 1.85315C16.9259 1.9518 17.3144 2.13225 17.5912 2.40901C17.868 2.68577 18.0484 3.07435 18.1471 3.80812C18.2486 4.56347 18.2502 5.56459 18.2502 7V15C18.2502 16.4354 18.2486 17.4365 18.1471 18.1919C18.0484 18.9257 17.868 19.3142 17.5912 19.591C17.3144 19.8678 16.9259 20.0482 16.1921 20.1469C15.4367 20.2484 14.4356 20.25 13.0002 20.25H12.0002C10.5648 20.25 9.56369 20.2484 8.80834 20.1469C8.07456 20.0482 7.68599 19.8678 7.40922 19.591C7.16577 19.3475 6.99859 19.0195 6.89448 18.4527C6.78643 17.8644 6.75803 17.0893 6.75194 15.9958C6.74964 15.5816 6.41199 15.2477 5.99778 15.25C5.58357 15.2523 5.24966 15.59 5.25197 16.0042Z" fill="#1C274C"/>
                    </svg>
                    <span class="text-sm mx-3"><?php echo e(__('common.logout')); ?></span>
                </button>
            </form>
        </div>
    </nav>
</div>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const dropdownMenus = document.querySelectorAll('[data-dropdown-menu]');
        const dropdownButtons = document.querySelectorAll('[data-dropdown-button]');
        dropdownMenus.forEach(menu => {
            if (menu.getAttribute('data-show') === 'true') {
                menu.classList.remove('hidden');
            } else {
                menu.classList.add('hidden');
            }
            menu.addEventListener('click', (e) => {
                e.stopPropagation();
            });
        });
        dropdownButtons.forEach(button => {
            button.addEventListener('click', function (e) {
                e.stopPropagation();
                const menu = this.nextElementSibling;
                const isHidden = menu.classList.contains('hidden');
                dropdownMenus.forEach(dropdown => {
                    if (dropdown !== menu) dropdown.classList.add('hidden');
                });
                if (isHidden) {
                    menu.classList.remove('hidden');
                } else {
                    menu.classList.add('hidden');
                }
            });
        });
        document.addEventListener('click', function () {
            dropdownMenus.forEach(menu => menu.classList.add('hidden'));
        });
    });
</script>
<?php /**PATH C:\xampp8.2\htdocs\Portal\resources\views/layouts/admin/sidebar.blade.php ENDPATH**/ ?>