{{-- resources/views/components/breadcrumbs.blade.php --}}
@props(['items' => []])

<nav class="text-gray-500 text-sm mb-4" aria-label="Breadcrumb">
    <ol class="list-reset flex">
        <li>
            <a href="{{ route('admin.dashboard') }}" class="text-green-700 hover:underline">{{__('common.dashboard')}}</a>
        </li>

        @foreach ($items as $item)
            <li><span class="mx-2">/</span></li>
            <li>
                @if(isset($item['url']))
                    <a href="{{ $item['url'] }}" class="text-black font-semibold hover:underline">{{ $item['label'] }}</a>
                @else
                    <span class="text-black font-semibold">{{ $item['label'] }}</span>
                @endif
            </li>
        @endforeach
    </ol>
</nav>
