<x-admin-layout>
    <x-slot name="header">
        <h1 class="text-2xl font-bold">Tour Details</h1>
    </x-slot>

    <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-md">
        <!-- Status -->
        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">Status</label>
            <p class="mt-1 text-gray-900 dark:text-gray-100">
                {{ $tour->status == 1 ? 'Published' : 'Unpublished' }}
            </p>
        </div>

        <!-- Tour Name -->
        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">Tour Name</label>
            <p class="mt-1 text-gray-900 dark:text-gray-100">{{ $tour->name }}</p>
        </div>

        <!-- Bokun ID -->
        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">Bokun ID</label>
            <p class="mt-1 text-gray-900 dark:text-gray-100">{{ $tour->bokun_id }}</p>
        </div>

        <!-- Bokun Title -->
        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">Bokun Title</label>
            <p class="mt-1 text-gray-900 dark:text-gray-100">{{ $tour->bokun_title }}</p>
        </div>

        <!-- Tour Time -->
        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">Time</label>
            <p class="mt-1 text-gray-900 dark:text-gray-100">{{ $tour->time }}</p>
        </div>

        <!-- Tour Start Time -->
        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">Start Time</label>
            <p class="mt-1 text-gray-900 dark:text-gray-100">{{ $tour->start_time }}</p>
        </div>

        <!-- Tour End Time -->
        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">End Time</label>
            <p class="mt-1 text-gray-900 dark:text-gray-100">{{ $tour->end_time }}</p>
        </div>


        <!-- Duration -->
        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">Duration</label>
            <p class="mt-1 text-gray-900 dark:text-gray-100">{{ $tour->duration }}</p>
        </div>

        <!-- Region -->
        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">Region</label>
            <p class="mt-1 text-gray-900 dark:text-gray-100">{{ $tour->region->eng_name ?? 'N/A' }}</p>
        </div>

        <!-- Prefecture -->
        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">Prefecture</label>
            <p class="mt-1 text-gray-900 dark:text-gray-100">{{ $tour->prefecture->eng_name ?? 'N/A' }}</p>
        </div>

        <!-- City -->
        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">City</label>
            <p class="mt-1 text-gray-900 dark:text-gray-100">{{ $tour->city->eng_name ?? 'N/A' }}</p>
        </div>

        <!-- Opteration Area -->
        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">Operation Area</label>
            <p class="mt-1 text-gray-900 dark:text-gray-100">{{ $tour->operation_area }}</p>
        </div>

        <!-- Operation lat/lng -->
        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">Operation lat/lng</label>
            <p class="mt-1 text-gray-900 dark:text-gray-100">{{ $tour->operation_lat_lng }}</p>
        </div>

        <!-- Guide Fee -->
        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">Guide Fee</label>
            <p class="mt-1 text-gray-900 dark:text-gray-100">{{ $tour->guide_free }}</p>
        </div>

        <!-- Manager -->
        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">Manager</label>
            <p class="mt-1 text-gray-900 dark:text-gray-100">{{ $tour->managers->pluck('name')->implode(', ') }}</p>
        </div>

        <!-- Link Form -->
        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">Link Form</label>
            <p class="mt-1 text-gray-900 dark:text-gray-100">{{ $tour->link_form }}</p>
        </div>

        <!-- Tour Instructions -->
        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">Tour Instructions</label>
            <p class="mt-1 text-gray-900 dark:text-gray-100">{{ $tour->tour_instructions }}</p>
        </div>

        <!-- Tour Type Table -->
        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-200 mb-2">Tour Type</label>
            <table class="border-collapse border border-gray-300">
                <thead>
                    <tr class="bg-gray-200">
                        <th class="border border-gray-300 px-4 py-2">Name</th>
                        <th class="border border-gray-300 px-4 py-2">Rate</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($tour->tourTypes as $tourType)
                        <tr>
                            <td class="border border-gray-300 px-4 py-2">{{ $tourType->name }}</td>
                            <td class="border border-gray-300 px-4 py-2">{{ $tourType->rate }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Meet Point Table -->
        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-200 m-b">Meet Points</label>
            <table class="border-collapse border border-gray-300">
                <thead>
                    <tr class="bg-gray-200">
                        <th class="border border-gray-300 px-4 py-2">Meet Point</th>
                        <th class="border border-gray-300 px-4 py-2">Latitude/Longitude</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $meetPoints = json_decode($tour->meet_point, true) ?? [];
                        $meetLatLng = json_decode($tour->meet_lat_lng, true) ?? [];
                    @endphp
                    @foreach ($meetPoints as $index => $meetPoint)
                        <tr>
                            <td class="border border-gray-300 px-4 py-2">{{ $meetPoint }}</td>
                            <td class="border border-gray-300 px-4 py-2">{{ $meetLatLng[$index] ?? 'N/A' }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Response Template -->
        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">Response Template</label>
            <p class="mt-1 text-gray-900 dark:text-gray-100">{{ $tour->groups->pluck('name')->implode(', ') }}</p>
        </div>

        <!-- Buttons -->
        <div class="flex items-center justify-between mt-6">
            <a href="{{ route('admin.tour_settings.index') }}" class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">
                Back to Tours List
            </a>
            <div class="flex items-center justify-end space-x-4">
                <a href="{{ route('admin.tour_settings.edit', $tour->id) }}" class="inline-flex items-center px-4 py-2 bg-indigo-600 border border-transparent rounded-md font-semibold text-white text-xs uppercase tracking-widest shadow-sm hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                    Edit Tour
                </a>
                <button type="submit" class="inline-flex items-center bg-red-500 border border-transparent text-white px-4 py-2 rounded-md font-semibold text-xs uppercase tracking-widest shadow-sm hover:bg-red-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-400" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $tour->id }}">Delete Tour</button>
                <x-delete-modal :type="'tour'" :id="$tour->id" :name="$tour->name" route="admin.tour_settings.destroy" />
            </div>
        </div>
    </div>
</x-admin-layout>
