<x-admin-layout>
    <x-slot name="header">
        <h1 class="text-2xl font-bold">Trashed Response Templates</h1>
    </x-slot>

    <div class="p-6 bg-white rounded-lg shadow-md dark:bg-gray-800">
        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
            <thead class="bg-gray-50 dark:bg-gray-800">
                <tr>
                    <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase dark:text-gray-400">Title</th>
                    <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase dark:text-gray-400">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($trashedTemplates as $template)
                    <tr>
                        <td class="px-6 py-4 text-sm text-gray-900 dark:text-gray-100">{{ $template->title }}</td>
                        <td class="px-6 py-4 text-sm text-gray-700 dark:text-gray-300">

                            <form action="{{ route('admin.response_templates.restore', ['id' => $template->id, 'group' => optional($template->groups->first())->id]) }}" method="POST">
                                @csrf
                                @method('PATCH')
                                <button type="submit" class="ml-4 text-green-600 dark:text-green-400 hover:text-green-900">Restore</button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="3" class="px-6 py-4 text-center text-gray-500 dark:text-gray-400">No trashed response templates found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>

        <div class="mt-4">
            {{ $trashedTemplates->links() }}
        </div>
    </div>
</x-admin-layout>
