<x-admin-layout>
    <x-slot name="header">
        <h1 class="text-2xl font-bold">Response Templates</h1>
    </x-slot>

    <x-message type="success" message="success" />
    <x-message type="danger" message="error" />

    <!-- Groups Section - Display as Folders in a Row -->
    <div class="p-4 bg-white dark:bg-gray-800">
        <h2 class="p-4 text-lg font-semibold text-gray-700 dark:text-gray-300">Groups</h2>

        <!-- Flexbox layout for proper row structure -->
        <div class="flex flex-wrap gap-4">
            @forelse($groups as $group)
            <a href="{{ route('admin.response_templates.index', ['group' => $group->id]) }}"
                class="w-[18%] sm:w-[18%] md:w-[18%] lg:w-[18%] xl:w-[18%] text-center p-4 rounded-lg shadow transition-all duration-200
                       {{ request('group') == $group->id ? 'bg-indigo-600 text-white' : 'bg-gray-100 text-gray-800 hover:bg-gray-200 dark:bg-gray-700 dark:hover:bg-gray-600' }}">
                 <svg class="w-12 h-12 mx-auto {{ request('group') == $group->id ? 'text-white' : 'text-gray-500 dark:text-gray-300' }}"
                      xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
                     <path d="M10 4H4C2.9 4 2 4.9 2 6V18C2 19.1 2.9 20 4 20H20C21.1 20 22 19.1 22 18V8C22 6.9 21.1 6 20 6H12L10 4Z"></path>
                 </svg>
                 <p class="mt-2 text-sm font-medium">
                     {{ $group->name }}
                 </p>
             </a>
            @empty
                <p class="text-gray-500 dark:text-gray-400">No groups available.</p>
            @endforelse
        </div>
    </div>

    <!-- Response Templates Table -->
    <div class="mt-4 mb-4 flex justify-between items-center">
        @can('response-template-enable-disable')
        <div>
            <a href="{{ route('admin.response_templates.enabled' , ['group' => request('group')]) }}" class="inline-flex items-center px-4 py-2 text-xs font-semibold tracking-widest uppercase border border-transparent rounded-md shadow-sm
                {{ request()->routeIs('admin.response_templates.disabled') ? 'bg-gray-300 text-black hover:bg-gray-400' : 'bg-blue-600 text-white hover:bg-blue-700' }}">
                View Enabled Templates
            </a>
            <a href="{{ route('admin.response_templates.disabled' , ['group' => request('group')]) }}" class="inline-flex items-center px-4 py-2 text-xs font-semibold tracking-widest uppercase border border-transparent rounded-md shadow-sm
                {{ request()->routeIs('admin.response_templates.disabled') ? 'bg-gray-600 text-white hover:bg-gray-700' : 'bg-gray-300 text-black hover:bg-gray-400' }}">
                View Disabled Templates
            </a>
        </div>
        @endcan
        @can('response-template-delete')
        <div>
            <a href="{{ route('admin.response_templates.trashed' , ['group' => request('group')]) }}"
                class="inline-flex items-center px-4 py-2 text-xs font-semibold tracking-widest text-white uppercase bg-red-600 border border-transparent rounded-md shadow-sm hover:bg-red-700">
                View Templates Trashed
            </a>
        </div>
        @endcan
    </div>
    <div class="p-6 bg-white rounded-lg shadow-md dark:bg-gray-800">
        <div class="hidden md:block">
            @can('response-template-add')
            <div class="flex items-center justify-between mb-4">
                <a href="{{ route('admin.response_templates.create', ['group' => request('group')]) }}"
                    class="inline-flex items-center px-4 py-2 text-xs font-semibold tracking-widest text-white uppercase bg-indigo-600 border border-transparent rounded-md shadow-sm hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                    Add New Response Template
                </a>
            </div>
            @endcan

            <h2 class="mb-4 text-lg font-semibold text-gray-700 dark:text-gray-300">Response Templates</h2>
            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                <thead class="bg-gray-50 dark:bg-gray-800">
                    <tr>
                        <th class="px-4 py-3 text-xs font-medium tracking-wider text-left text-gray-500 uppercase dark:text-gray-400">Title</th>
                        <th class="px-4 py-3 text-xs font-medium tracking-wider text-left text-gray-500 uppercase dark:text-gray-400">Write To</th>
                        <th class="px-4 py-3 text-xs font-medium tracking-wider text-left text-gray-500 uppercase dark:text-gray-400">Reason</th>
                        <th class="px-4 py-3 text-xs font-medium tracking-wider text-left text-gray-500 uppercase dark:text-gray-400">Stage</th>
                        <th class="px-4 py-3 text-xs font-medium tracking-wider text-left text-gray-500 uppercase dark:text-gray-400">Type</th>
                        <th class="px-4 py-3 text-xs font-medium tracking-wider text-left text-gray-500 uppercase dark:text-gray-400">Subject</th>
                        <th class="px-4 py-3 text-xs font-medium tracking-wider text-left text-gray-500 uppercase dark:text-gray-400">Groups</th>
                        <th class="px-4 py-3 text-xs font-medium tracking-wider text-left text-gray-500 uppercase dark:text-gray-400">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200 dark:bg-gray-900 dark:divide-gray-700">
                    @forelse($responseTemplates as $template)
                        <tr>
                            <td class="px-2 py-4 text-sm font-medium text-gray-900 whitespace-nowrap dark:text-gray-100">{{ $template->title }}</td>
                            <td class="px-2 py-4 text-sm text-gray-700 dark:text-gray-300">{{ $template->write_to }}</td>
                            <td class="px-2 py-4 text-sm text-gray-700 dark:text-gray-300">{{ $template->reason }}</td>
                            <td class="px-2 py-4 text-sm text-gray-700 dark:text-gray-300">{{ $template->stage_of_booking }}</td>
                            <td class="px-2 py-4 text-sm text-gray-700 dark:text-gray-300">{{ $template->type }}</td>
                            <td class="px-2 py-4 text-sm text-gray-700 dark:text-gray-300">{{ $template->subject }}</td>
                            <td class="px-2 py-4 text-sm text-gray-700 dark:text-gray-300">{{ $template->groups->pluck('name')->implode(', ') }}</td>
                            <td class="px-2 py-4 text-sm font-medium whitespace-nowrap">
                                <a href="{{ route('admin.response_templates.show', $template) }}" class="text-indigo-600 dark:text-indigo-400 hover:text-indigo-900 dark:hover:text-indigo-300">View</a>
                                @if ($template->status)
                                @can('response-template-edit')
                                <a href="{{ route('admin.response_templates.edit', $template) }}" class="ml-2 text-indigo-600 dark:text-indigo-400 hover:text-indigo-900 dark:hover:text-indigo-300">Edit</a>
                                @endcan
                                @can('response-template-delete')
                                <button type="button" class="inline ml-2 text-red-600 dark:text-red-400 hover:text-red-900 dark:hover:text-red-300" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $template->id }}">
                                    Delete
                                </button>
                                <x-delete-modal :type="'Response Template'" :id="$template->id" :name="$template->title" route="admin.response_templates.destroy" />
                                @endcan
                                @endif
                                @can('response-template-enable-disable')
                                <button type="button" class="ml-2 px-3 py-1 text-white text-xs font-semibold rounded-md {{ $template->status ? 'bg-green-500 hover:bg-green-600' : 'bg-gray-500 hover:bg-gray-600' }}" data-bs-toggle="modal" data-bs-target="#statusModal{{ $template->id }}">
                                    {{ $template->status ? 'Enable' : 'Disable' }}
                                </button>
                                <!-- Status Modal Component -->
                                <x-status-modal :type="$template->status ? 'Disable' : 'Enable'" :id="$template->id" :name="$template->title" route="admin.response_templates.toggle-status" />
                                @endcan
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="px-6 py-4 text-center text-gray-500 dark:text-gray-400">
                                No response templates found.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
            <!-- Pagination -->
            <div class="mt-4">
                {{ $responseTemplates->links() }}
            </div>
        </div>
    </div>
</x-admin-layout>
