<x-admin-layout>
    <x-slot name="header">
        <h1 class="text-2xl font-bold">Trashed Channels</h1>
    </x-slot>

    <div class="p-6 bg-white rounded-lg shadow-md dark:bg-gray-800">
        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
            <thead class="bg-gray-50 dark:bg-gray-800">
                <tr>
                    <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase dark:text-gray-400">Name</th>
                    {{-- <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase dark:text-gray-400">Actions</th> --}}
                </tr>
            </thead>
            <tbody>
                @forelse($channels as $channel)
                <tr>
                    <td class="px-6 py-4 text-sm text-gray-900 dark:text-gray-100">{{ $channel->name }}</td>
                    {{-- <td class="px-6 py-4 text-sm">
                        <form action="{{ route('admin.channels.restore', $channel->id) }}" method="POST" class="inline">
                            @csrf
                            <button type="submit" class="text-green-600 dark:text-green-400 hover:text-green-900">Restore</button>
                        </form>
                        <form action="{{ route('admin.channels.force-delete', $channel->id) }}" method="POST" class="inline ml-4">
                            @csrf
                            <button type="submit" class="text-red-600 dark:text-red-400 hover:text-red-900">Delete Permanently</button>
                        </form>
                    </td> --}}
                </tr>
                @empty
                <tr>
                    <td colspan="3" class="px-6 py-4 text-center text-gray-500 dark:text-gray-400">No trashed Channels found.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</x-admin-layout>
