<x-admin-layout>
    <x-slot name="header">
        <h1 class="text-2xl font-bold">Channel List</h1>
    </x-slot>
    <x-message type="success" message="success" />
    <x-message type="danger" message="error" />
    <div class="mb-4 flex justify-between items-center">
        @can('channel-enable-disable')
        <div>
            <a href="{{ route('admin.channels.enabled') }}" class="inline-flex items-center px-4 py-2 text-xs font-semibold tracking-widest uppercase border border-transparent rounded-md shadow-sm
                {{ request()->routeIs('admin.channels.disabled') ? 'bg-gray-300 text-black hover:bg-gray-400' : 'bg-blue-600 text-white hover:bg-blue-700' }}">
                View Enabled Channels
            </a>
            <a href="{{ route('admin.channels.disabled') }}" class="inline-flex items-center px-4 py-2 text-xs font-semibold tracking-widest uppercase border border-transparent rounded-md shadow-sm
                {{ request()->routeIs('admin.channels.disabled') ? 'bg-gray-600 text-white hover:bg-gray-700' : 'bg-gray-300 text-black hover:bg-gray-400' }}">
                View Disabled Channels
            </a>
        </div>
        @endcan
        {{-- @can('channel-delete')
        <div>
            <a href="{{ route('admin.channels.trashed') }}" class="inline-flex items-center px-4 py-2 text-xs font-semibold tracking-widest text-white uppercase bg-red-600 rounded-md shadow-sm hover:bg-red-700">
                View Trashed Channels
            </a>
        </div>
        @endcan --}}
    </div>

    <div class="p-6 bg-white rounded-lg shadow-md dark:bg-gray-800">
        <!-- Desktop View -->
        <div class="hidden md:block">
            @can('channel-addd')
            <div class="flex items-center justify-between mb-4">
                <a id="addUserButton" href="{{ route('admin.channels.create') }}" class="inline-flex items-center px-4 py-2 text-xs font-semibold tracking-widest text-white uppercase bg-indigo-600 border border-transparent rounded-md shadow-sm hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                    Add New Channel
                </a>
            </div>
            @endcan
            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                <thead class="bg-gray-50 dark:bg-gray-800">
                    <tr>
                        <th class="px-6 py-3 text-xs font-medium tracking-wider text-left text-gray-500 uppercase dark:text-gray-400">Name</th>
                        <th class="px-6 py-3 text-xs font-medium tracking-wider text-left text-gray-500 uppercase dark:text-gray-400">Actions</th>
                    </tr>
                </thead>
                <tbody id="userTable" class="bg-white divide-y divide-gray-200 dark:bg-gray-900 dark:divide-gray-700">
                    @forelse($channels as $channel)
                    <tr>
                            <td class="px-6 py-4 text-sm font-medium text-gray-900 whitespace-nowrap dark:text-gray-100">{{ $channel->name }}</td>
                            <td class="px-6 py-4 text-sm font-medium whitespace-nowrap">
                                <a href="{{ route('admin.channels.show', $channel) }}" class="text-indigo-600 dark:text-indigo-400 hover:text-indigo-900 dark:hover:text-indigo-300">View</a>
                                @if($channel->status)
                                @can('channel-edit')
                                <a href="{{ route('admin.channels.edit', $channel) }}" class="ml-4 text-indigo-600 dark:text-indigo-400 hover:text-indigo-900 dark:hover:text-indigo-300">Edit</a>
                                @endcan
                                @can('channel-delete')
                                <button type="button" class="inline ml-4 text-red-600 dark:text-red-400 hover:text-red-900 dark:hover:text-red-300" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $channel->id }}">
                                    Delete
                                </button>
                                <!-- Delete Modal Component -->
                                <x-delete-modal :type="'channel'" :id="$channel->id" :name="$channel->name" route="admin.channels.destroy" />
                                @endcan
                                @endif
                                @can('channel-enable-disable')
                                <button type="button" class="ml-4 px-3 py-1 text-white text-xs font-semibold rounded-md {{ $channel->status ? 'bg-green-500 hover:bg-green-600' : 'bg-gray-500 hover:bg-gray-600' }}" data-bs-toggle="modal" data-bs-target="#statusModal{{ $channel->id }}">
                                    {{ $channel->status ? 'Enable' : 'Disable' }}
                                </button>
                                <!-- Status Modal Component -->
                                <x-status-modal :type="$channel->status ? 'Disable' : 'Enable'" :id="$channel->id" :name="$channel->name" route="admin.channels.toggle-status" />
                                @endcan
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="px-6 py-4 text-center text-gray-500 dark:text-gray-400">
                                No Channels found.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</x-admin-layout>
