<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('user_image')->nullable();
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('personal_email')->nullable();
            $table->text('work_email')->nullable();
            $table->text('share_email')->nullable();
            $table->string('gender')->nullable();
            $table->integer('age')->nullable();
            $table->date('birth_date')->nullable();
            $table->string('residence')->nullable();
            $table->string('operating_location')->nullable();
            $table->string('detail')->nullable();
            $table->text('phone_number')->nullable();
            $table->text('phone_number_type')->nullable();
            $table->text('local_number')->nullable();
            $table->text('local_number_type')->nullable();
            $table->text('address')->nullable();
            $table->text('other_address')->nullable();
            $table->string('line_name')->nullable();
            $table->text('bank_info')->nullable();
            $table->text('other')->nullable();
            $table->text('working_hours')->nullable();
            $table->text('working_hours_other')->nullable();
            $table->date('started_on')->nullable();
            $table->string('line_group_chat')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['user_image','first_name','last_name','personal_email','work_email','share_email','gender','age','birth_date','residence','operating_location','detail','phone','address','other_address','line_name','bank_info','other','started_on','line_group_chat','working_hours','working_hours_other','phone_number','phone_number_type','local_number','local_number_type']);
        });
    }
};
